/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.SystemBundle;
import org.nuxeo.osgi.application.ClassPath;
import org.nuxeo.osgi.application.CommandLineOptions;
import org.nuxeo.osgi.application.SharedClassLoader;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneApplication
extends OSGiAdapter {
    public static final String MAIN_TASK = "org.nuxeo.osgi.application.main.task";
    private static final Log log = LogFactory.getLog(StandaloneApplication.class);
    private static StandaloneApplication instance;
    private static CommandLineOptions options;
    private static String[] args;
    private static Runnable mainTask;
    protected final SharedClassLoader classLoader;
    protected final Environment env;
    protected boolean isStarted;
    protected File home;
    protected List<File> classPath;
    protected boolean scanForNestedJARs = true;
    protected String[] libdirs;

    public static StandaloneApplication getInstance() {
        return instance;
    }

    public static StandaloneApplication createInstance(SharedClassLoader cl) throws IOException {
        String[] ar;
        String javaLibsProp;
        if (instance != null) {
            throw new IllegalStateException("Application already instantiated");
        }
        Environment env = StandaloneApplication.createEnvironment();
        Environment.setDefault((Environment)env);
        instance = new StandaloneApplication(cl, env);
        String val = options.getOption("scanForNestedJARs");
        if (val != null) {
            StandaloneApplication.instance.scanForNestedJARs = Boolean.parseBoolean(val);
        }
        if ((javaLibsProp = System.getProperty("org.nuxeo.launcher.libdirs")) != null && (ar = StringUtils.split((String)javaLibsProp, (char)',', (boolean)false)).length > 0) {
            StandaloneApplication.instance.libdirs = ar;
            File wd = instance.getWorkingDir();
            for (int i = 0; i < ar.length; ++i) {
                if (ar[i].startsWith("/")) continue;
                StandaloneApplication.instance.libdirs[i] = new File(wd, ar[i]).getCanonicalFile().getAbsolutePath();
            }
        }
        return instance;
    }

    private StandaloneApplication(SharedClassLoader cl, Environment env) {
        super(env.getHome(), env.getData(), env.getProperties());
        this.classLoader = cl;
        this.env = env;
    }

    public SharedClassLoader getSharedClassLoader() {
        return this.classLoader;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public void start() throws Exception {
        if (this.isStarted) {
            throw new IllegalStateException("OSGi Application is already started");
        }
        List<BundleFile> preBundles = this.loadUserBundles("pre-bundles");
        List<BundleFile> postBundles = this.loadUserBundles("post-bundles");
        if (preBundles != null) {
            this.startBundles(preBundles);
        }
        this.autoInstallBundles();
        if (postBundles != null) {
            this.startBundles(postBundles);
        }
        this.fireFrameworkEvent(new FrameworkEvent(1, this.getSystemBundle(), null));
        this.isStarted = true;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws IOException {
        if (!this.isStarted) {
            throw new IllegalStateException("OSGi Application was not started");
        }
        try {
            super.shutdown();
        }
        finally {
            this.isStarted = false;
        }
    }

    protected void startBundles(List<BundleFile> bundles) throws Exception {
        for (BundleFile bf : bundles) {
            this.install(new BundleImpl(this, bf, this.classLoader.getLoader()));
        }
    }

    protected List<BundleFile> loadUserBundles(String key) throws Exception {
        String[] ar;
        if (options == null) {
            return null;
        }
        String bundlesString = options.getOption(key);
        if (bundlesString == null) {
            return null;
        }
        ArrayList<BundleFile> bundles = new ArrayList<BundleFile>();
        for (String entry : ar = StringUtils.split((String)bundlesString, (char)':', (boolean)true)) {
            File file;
            if (entry.contains("file:")) {
                URL url = new URL(entry);
                file = new File(url.toURI());
            } else {
                file = new File(entry);
            }
            BundleFile bf = file.isDirectory() ? new DirectoryBundleFile(file) : new JarBundleFile(file);
            this.classLoader.addURL(bf.getURL());
            bundles.add(bf);
        }
        return bundles;
    }

    public List<File> getClassPath() {
        return this.classPath;
    }

    public void setClassPath(List<File> classPath) {
        this.classPath = classPath;
    }

    protected void autoInstallBundles() throws Exception {
        List<File> cp = this.getClassPath();
        if (cp == null || cp.isEmpty()) {
            return;
        }
        boolean clear = StandaloneApplication.hasCommandLineOption("clear");
        ClassPath cpath = new ClassPath(this.classLoader, new File(this.env.getData(), "nested-jars"));
        File cache = new File(this.env.getData(), "bundles.cache");
        if (!clear && cache.exists()) {
            try {
                cpath.restore(cache);
            }
            catch (BundleException e) {
                cpath.scan(this.classPath, this.scanForNestedJARs, this.libdirs);
                cpath.store(cache);
            }
        } else {
            cpath.scan(this.classPath, this.scanForNestedJARs, this.libdirs);
            cpath.store(cache);
        }
        this.installAll(cpath.getBundles());
    }

    public void install(BundleFile bf) throws BundleException {
        this.install(new BundleImpl(this, bf, this.classLoader.getLoader()));
    }

    public void installAll(List<BundleFile> bundles) throws BundleException {
        for (BundleFile bf : bundles) {
            this.install(new BundleImpl(this, bf, this.classLoader.getLoader()));
        }
    }

    public static BundleFile createSystemBundle(URL systemBundle) throws URISyntaxException, IOException {
        File file = new File(systemBundle.toURI());
        BundleFile sysbf = null;
        sysbf = file.isFile() ? new JarBundleFile(file) : new DirectoryBundleFile(file);
        return sysbf;
    }

    public static CommandLineOptions getComandLineOptions() {
        return options;
    }

    public static boolean hasCommandLineOption(String option) {
        return options != null && options.hasOption(option);
    }

    public static Environment createEnvironment() throws IOException {
        if (options != null) {
            String val = options.getOption("home");
            if (val == null && (val = System.getProperty("org.nuxeo.app.home")) == null) {
                val = ".";
            }
            File home = new File(val);
            home = home.getCanonicalFile();
            Environment env = new Environment(home);
            env.setCommandLineArguments(args);
            val = options.getOption("data");
            if (val != null) {
                env.setData(new File(val).getCanonicalFile());
            }
            if ((val = options.getOption("log")) != null) {
                env.setLog(new File(val).getCanonicalFile());
            }
            if ((val = options.getOption("config")) != null) {
                env.setConfig(new File(val).getCanonicalFile());
            }
            if ((val = options.getOption("web")) != null) {
                env.setWeb(new File(val).getCanonicalFile());
            }
            if ((val = options.getOption("tmp")) != null) {
                env.setTemp(new File(val).getCanonicalFile());
            }
            if ((val = options.getOption("bundles")) != null) {
                env.setProperty("nuxeo.osgi.bundles", val);
            }
            env.setHostApplicationName("NXServer");
            env.setHostApplicationVersion("1.0.0");
            env.getData().mkdirs();
            env.getLog().mkdirs();
            env.getTemp().mkdirs();
            return env;
        }
        return new Environment(new File("").getCanonicalFile());
    }

    public static void setMainTask(Runnable mainTask) {
        StandaloneApplication.mainTask = mainTask;
    }

    public static Runnable getMainTask() {
        return mainTask;
    }

    public static void main(URL systemBundle, List<File> classPath, String[] args) {
        SharedClassLoader classLoader = (SharedClassLoader)((Object)Thread.currentThread().getContextClassLoader());
        long startTime = System.currentTimeMillis();
        StandaloneApplication.args = args;
        options = new CommandLineOptions(args);
        try {
            StandaloneApplication app = StandaloneApplication.createInstance(classLoader);
            app.setClassPath(classPath);
            app.setSystemBundle(new SystemBundle(app, StandaloneApplication.createSystemBundle(systemBundle), classLoader.getLoader()));
            app.start();
            log.info((Object)("Framework started in " + (System.currentTimeMillis() - startTime) / 1000L + " sec."));
            if (mainTask != null) {
                mainTask.run();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(13);
        }
    }
}

