/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.backend.indexing.resources.impl;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedData;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedResource;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.IndexableResource;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceConf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedResourceImpl
implements ResolvedResource {
    private static final long serialVersionUID = -8173983658947817695L;
    protected String id;
    protected IndexableResource resourceProxy;
    protected List<ResolvedData> data;

    public ResolvedResourceImpl() {
    }

    public ResolvedResourceImpl(String id) {
        this.id = id;
    }

    public ResolvedResourceImpl(String id, IndexableResource resourceProxy, List<ResolvedData> data) {
        this.id = id;
        this.resourceProxy = resourceProxy;
        this.data = data;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<ResolvedData> getIndexableData() {
        return this.data;
    }

    @Override
    public IndexableResource getIndexableResource() {
        return this.resourceProxy;
    }

    @Override
    public ResolvedData getIndexableDataByName(String name) {
        ResolvedData res = null;
        if (this.data != null) {
            for (ResolvedData one : this.data) {
                if (!one.getName().equals(name)) continue;
                res = one;
                break;
            }
        }
        return res;
    }

    @Override
    public IndexableResourceConf getConfiguration() {
        IndexableResourceConf conf = null;
        if (this.resourceProxy != null) {
            conf = this.resourceProxy.getConfiguration();
        }
        return conf;
    }

    @Override
    public void addIndexableData(ResolvedData one) {
        if (this.data == null) {
            this.data = new ArrayList<ResolvedData>();
        }
        this.data.add(one);
    }

    @Override
    public void setIndexableResource(IndexableResource resource) {
        this.resourceProxy = resource;
    }

    public String toString() {
        String className = this.getClass().getSimpleName();
        if (this.resourceProxy == null) {
            return String.format("%s (uninitialized)", className);
        }
        return String.format("%s (for '%s')", this.getClass().getSimpleName(), this.getConfiguration().getName());
    }
}

