/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.indexing.resources;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.IndexableResource;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceConf;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractIndexableResource
implements IndexableResource {
    private static final Log log = LogFactory.getLog(AbstractIndexableResource.class);
    private static final long serialVersionUID = 7457965764411626518L;
    protected String name;
    protected IndexableResourceConf configuration;
    private LoginContext loginCtx;

    protected AbstractIndexableResource() {
    }

    protected AbstractIndexableResource(String name, IndexableResourceConf configuration) {
        this.name = name;
        this.configuration = configuration;
    }

    public String getName() {
        return this.name;
    }

    public IndexableResourceConf getConfiguration() {
        return this.configuration;
    }

    protected void login() {
        try {
            this.loginCtx = Framework.login();
            log.debug((Object)"Authenticating against the nuxeo security domain.");
        }
        catch (Exception e) {
            log.warn((Object)("Cannot authenticated against the nuxeo security domain...." + e.getMessage()));
        }
    }

    protected void logout() {
        if (this.loginCtx != null) {
            try {
                this.loginCtx.logout();
                log.debug((Object)"Logout from the nuxeo security domain");
            }
            catch (LoginException le) {
                log.warn((Object)"Failed to logout from the nuxeo security domain");
            }
        }
    }

    public ACP computeAcp() {
        return null;
    }
}

