/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.indexing.resources.document.factory;

import java.io.Serializable;
import java.util.ArrayList;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedData;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedResource;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedResources;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.impl.ResolvedDataImpl;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.impl.ResolvedResourceImpl;
import org.nuxeo.ecm.core.search.api.client.IndexingException;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.AbstractIndexableResourceFactory;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.IndexableResource;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.document.DocumentIndexableResource;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.document.impl.DocumentBuiltinsIndexableResourceImpl;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceConf;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceDataConf;

public class DocumentBuiltinsIndexableResourceFactory
extends AbstractIndexableResourceFactory {
    private static final long serialVersionUID = 1L;

    public ResolvedResource resolveResourceFor(IndexableResource resource) throws IndexingException {
        IndexableResourceConf conf = resource.getConfiguration();
        if (!conf.getType().equals("documentBuiltins")) {
            throw new IndexingException("Factory expects a resource of type=documentBuiltins");
        }
        ArrayList<ResolvedData> rdata = new ArrayList<ResolvedData>();
        for (IndexableResourceDataConf dataConf : conf.getIndexableFields().values()) {
            String name = dataConf.getIndexingName();
            String prefix = conf.getPrefix();
            String prefixedName = prefix + ':' + name;
            Serializable value = resource.getValueFor(prefixedName);
            rdata.add(new ResolvedDataImpl(prefixedName, dataConf.getIndexingAnalyzer(), dataConf.getIndexingType(), value, dataConf.isStored(), dataConf.isIndexed(), dataConf.isMultiple(), dataConf.isSortable(), null, dataConf.getTermVector(), dataConf.isBinary(), null));
        }
        return new ResolvedResourceImpl(((DocumentIndexableResource)resource).getDocUUID(), resource, rdata);
    }

    public IndexableResource createEmptyIndexableResource() {
        return new DocumentBuiltinsIndexableResourceImpl();
    }

    public IndexableResource createIndexableResourceFrom(Serializable targetResource, IndexableResourceConf conf, String sid) {
        return new DocumentBuiltinsIndexableResourceImpl((DocumentModel)targetResource, conf, sid);
    }

    public ResolvedResources resolveResourcesFor(IndexableResource resource) {
        return null;
    }
}

