/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.GroupByClause;
import org.nuxeo.ecm.core.query.sql.model.HavingClause;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.OperandList;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.ReferenceList;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.SelectList;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.query.sql.model.WhereClause;

public class DefaultQueryVisitor
implements IVisitor {
    private static final long serialVersionUID = 1L;

    public void visitQuery(SQLQuery node) {
        node.select.accept(this);
        node.from.accept(this);
        if (node.where != null) {
            node.where.accept(this);
        }
        if (node.orderBy != null) {
            node.orderBy.accept(this);
        }
        if (node.groupBy != null) {
            node.groupBy.accept(this);
        }
        if (node.having != null) {
            node.having.accept(this);
        }
    }

    public void visitSelectClause(SelectClause node) {
        SelectList elements = node.elements;
        for (int i = 0; i < elements.size(); ++i) {
            ((Operand)elements.get(i)).accept(this);
        }
    }

    public void visitFromClause(FromClause node) {
    }

    public void visitWhereClause(WhereClause node) {
        node.predicate.accept(this);
    }

    public void visitGroupByClause(GroupByClause node) {
    }

    public void visitHavingClause(HavingClause node) {
        if (node.predicate != null) {
            node.predicate.accept(this);
        }
    }

    public void visitOrderByClause(OrderByClause node) {
        node.elements.accept(this);
    }

    public void visitOrderByList(OrderByList node) {
        for (int i = 0; i < node.size(); ++i) {
            ((OrderByExpr)node.get(i)).accept(this);
        }
    }

    public void visitOrderByExpr(OrderByExpr node) {
        node.reference.accept(this);
    }

    public void visitExpression(Expression node) {
        if (node.rvalue == null) {
            node.operator.accept(this);
            node.lvalue.accept(this);
        } else {
            node.lvalue.accept(this);
            node.operator.accept(this);
            node.rvalue.accept(this);
        }
    }

    public void visitMultiExpression(MultiExpression node) {
        for (Operand operand : node.values) {
            operand.accept(this);
        }
    }

    public void visitOperator(Operator node) {
    }

    public void visitReference(Reference node) {
    }

    public void visitReferenceList(ReferenceList node) {
        for (Reference reference : node) {
            reference.accept(this);
        }
    }

    public void visitLiteral(Literal node) {
    }

    public void visitLiteralList(LiteralList node) {
        for (Literal literal : node) {
            literal.accept(this);
        }
    }

    public void visitDateLiteral(DateLiteral node) {
        this.visitLiteral(node);
    }

    public void visitStringLiteral(StringLiteral node) {
        this.visitLiteral(node);
    }

    public void visitDoubleLiteral(DoubleLiteral node) {
        this.visitLiteral(node);
    }

    public void visitIntegerLiteral(IntegerLiteral node) {
        this.visitLiteral(node);
    }

    public void visitFunction(Function node) {
        for (Operand operand : node.args) {
            operand.accept(this);
        }
    }

    public void visitOperandList(OperandList node) {
        for (Operand operand : node) {
            operand.accept(this);
        }
    }
}

