/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.collections;

import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableArrayMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int DEFAULT_SIZE = 8;
    protected static final int GROW_SIZE = 10;
    protected int count = 0;
    protected Serializable[] elements;

    public SerializableArrayMap() {
    }

    public SerializableArrayMap(int initialCapacity) {
        this.elements = new Serializable[initialCapacity == 0 ? 8 : initialCapacity * 2];
    }

    public SerializableArrayMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    public SerializableArrayMap(SerializableArrayMap map) {
        this.count = map.count;
        this.elements = new Serializable[map.elements.length];
        System.arraycopy(map.elements, 0, this.elements, 0, this.count * 2);
    }

    public void putAll(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Serializable o = (Serializable)((Object)entry);
            K key = entry.getKey();
            V value = entry.getValue();
            this.add(key, value);
        }
    }

    public V remove(K key) {
        if (this.elements == null || this.count == 0) {
            return null;
        }
        for (int i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] == null || !this.elements[i].equals(key)) continue;
            return this._remove(i);
        }
        return null;
    }

    public V remove(int index) {
        if (this.elements == null || this.count == 0) {
            return null;
        }
        return this._remove(index << 1);
    }

    protected final V _remove(int i) {
        Serializable result = this.elements[i + 1];
        int len = this.count * 2;
        if (i + 2 == len) {
            this.elements[i] = null;
            this.elements[i + 1] = null;
        } else {
            int k = i + 2;
            System.arraycopy(this.elements, k, this.elements, i, len - k);
        }
        --this.count;
        return (V)result;
    }

    public V get(K key) {
        if (this.elements == null || this.count == 0) {
            return null;
        }
        for (int i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] == null || !this.elements[i].equals(key)) continue;
            return (V)this.elements[i + 1];
        }
        return null;
    }

    public V get(int i) {
        if (this.elements == null || i >= this.count) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return (V)this.elements[(i << 1) + 1];
    }

    public K getKey(Serializable value) {
        if (this.elements == null || this.count == 0) {
            return null;
        }
        for (int i = 1; i < this.elements.length; i += 2) {
            if (this.elements[i] == null || !this.elements[i].equals(value)) continue;
            return (K)this.elements[i - 1];
        }
        return null;
    }

    public K getKey(int i) {
        if (this.elements == null || i >= this.count) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return (K)this.elements[i << 1];
    }

    public V put(K key, V value) {
        if (this.elements == null) {
            this.elements = new Serializable[8];
        }
        if (this.count == 0) {
            this.elements[0] = (Serializable)key;
            this.elements[1] = (Serializable)value;
            ++this.count;
            return null;
        }
        int insertIndex = this.count * 2;
        for (int i = 0; i < insertIndex; i += 2) {
            if (!this.elements[i].equals(key)) continue;
            Serializable oldValue = this.elements[i + 1];
            this.elements[i + 1] = (Serializable)value;
            return (V)oldValue;
        }
        if (this.elements.length <= insertIndex) {
            this.grow();
        }
        this.elements[insertIndex] = (Serializable)key;
        this.elements[insertIndex + 1] = (Serializable)value;
        ++this.count;
        return null;
    }

    public void add(K key, V value) {
        int insertIndex;
        if (this.elements == null) {
            this.elements = new Serializable[8];
            insertIndex = 0;
        } else {
            insertIndex = this.count * 2;
            if (this.elements.length <= insertIndex) {
                this.grow();
            }
        }
        this.elements[insertIndex] = (Serializable)key;
        this.elements[insertIndex + 1] = (Serializable)value;
        ++this.count;
    }

    public void trimToSize() {
        int len = this.count * 2;
        if (len < this.elements.length) {
            Serializable[] tmp = new Serializable[len];
            System.arraycopy(this.elements, 0, tmp, 0, len);
            this.elements = tmp;
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void clear() {
        this.elements = null;
        this.count = 0;
    }

    protected void grow() {
        Serializable[] expanded = new Serializable[this.elements.length + 10];
        System.arraycopy(this.elements, 0, expanded, 0, this.elements.length);
        this.elements = expanded;
    }

    public Serializable[] getArray() {
        return this.elements;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SerializableArrayMap) {
            SerializableArrayMap map = (SerializableArrayMap)obj;
            if (this.count != map.count) {
                return false;
            }
            int len = this.count << 1;
            for (int i = 0; i < len; i += 2) {
                Serializable key1 = this.elements[i];
                Serializable key2 = map.elements[i];
                if (!key1.equals(key2)) {
                    return false;
                }
                Serializable val1 = this.elements[i + 1];
                Serializable val2 = map.elements[i + 1];
                if (!(val1 == null ? val1 != val2 : !val1.equals(val2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        for (int i = 0; i < this.count * 2; ++i) {
            result = result * 37 + this.elements[i].hashCode();
        }
        return result;
    }
}

