/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.binding;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.nuxeo.runtime.binding.BeanServiceProvider;
import org.nuxeo.runtime.binding.Binding;
import org.nuxeo.runtime.binding.RuntimeServiceProvider;
import org.nuxeo.runtime.binding.ServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManager
implements org.nuxeo.runtime.ServiceManager {
    protected ServiceProvider[] providers;
    protected Map<String, Binding> bindings = new ConcurrentHashMap<String, Binding>();

    public ServiceManager(ServiceProvider ... providers) {
        this.providers = providers;
    }

    public ServiceManager() throws NamingException {
        this(new BeanServiceProvider(), new RuntimeServiceProvider());
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        String bindingKey = serviceClass.getName();
        Binding binding = this.bindings.get(bindingKey);
        if (binding != null) {
            Object obj = binding.get();
            if (obj == null) {
                this.bindings.remove(bindingKey);
            } else {
                return (T)obj;
            }
        }
        return (T)this.findService(serviceClass, bindingKey);
    }

    @Override
    public <T> T getService(Class<T> serviceClass, String key) throws Exception {
        String bindingKey = serviceClass.getName() + "@" + key;
        Binding binding = this.bindings.get(bindingKey);
        if (binding != null) {
            Object obj = binding.get();
            if (obj == null) {
                this.bindings.remove(bindingKey);
            } else {
                return (T)obj;
            }
        }
        return (T)this.findService(serviceClass, bindingKey);
    }

    public Object findService(Class<?> serviceClass, String bindingKey) {
        for (ServiceProvider provider : this.providers) {
            Object obj = provider.getService(serviceClass, bindingKey);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public void registerBinding(String name, Binding binding) {
        this.bindings.put(name, binding);
    }

    public void unregisterBinding(String name) {
        this.bindings.remove(name);
    }

    public void clearBindings() {
        this.bindings.clear();
    }

    public ServiceProvider[] getProviders() {
        return this.providers;
    }

    protected void destroyProviders() {
        if (this.providers != null) {
            for (ServiceProvider provider : this.providers) {
                provider.destroy();
            }
        }
        this.bindings = new ConcurrentHashMap<String, Binding>();
    }

    public void setProviders(ServiceProvider ... providers) {
        this.destroyProviders();
        this.providers = providers;
    }

    public void addProvider(ServiceProvider provider) {
        this.bindings = new ConcurrentHashMap<String, Binding>();
        if (this.providers == null) {
            this.providers = new ServiceProvider[]{provider};
        } else {
            ServiceProvider[] tmp = new ServiceProvider[this.providers.length + 1];
            System.arraycopy(this.providers, 0, tmp, 0, this.providers.length);
            tmp[this.providers.length] = provider;
            this.providers = tmp;
        }
    }
}

