/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.runtime.service.AdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptableDescriptor {
    public static final Class<?>[] EMPTY_CLASSES = new Class[0];
    protected final Class<?> adaptable;
    protected final Map<Class<?>, AdapterFactory<?>> factories;
    protected Class<?>[] superTypes;

    public AdaptableDescriptor(Class<?> adaptable) {
        this.adaptable = adaptable;
        this.factories = new ConcurrentHashMap();
    }

    public Class<?> getAdaptable() {
        return this.adaptable;
    }

    public Class<?>[] getSuperTypes() {
        if (this.superTypes == null) {
            this.superTypes = AdaptableDescriptor.collectSuperTypes(this.adaptable);
        }
        return this.superTypes;
    }

    public AdapterFactory<?> getAdapterFactory(Class<?> adapter) {
        return this.factories.get(adapter);
    }

    public void addAdapterFactory(Class<?> adapter, AdapterFactory<?> factory) {
        this.factories.put(adapter, factory);
    }

    public void removeAdapterFactory(Class<?> adapter, AdapterFactory<?> factory) {
        this.factories.remove(adapter);
    }

    public static Class<?>[] collectSuperTypes(Class<?> klass) {
        ArrayList superClasses = new ArrayList();
        ArrayList interfaces = new ArrayList();
        AdaptableDescriptor.collectSuperTypes(klass, superClasses, interfaces);
        if (!interfaces.isEmpty()) {
            superClasses.addAll(interfaces);
        }
        if (superClasses.isEmpty()) {
            return EMPTY_CLASSES;
        }
        return superClasses.toArray(new Class[superClasses.size()]);
    }

    public static void collectSuperTypes(Class<?> klass, List<Class<?>> superClasses, List<Class<?>> interfaces) {
        Class<?> superClass;
        Class<?>[] itfs = klass.getInterfaces();
        if (itfs.length > 0) {
            interfaces.addAll(Arrays.asList(itfs));
        }
        if ((superClass = klass.getSuperclass()) != null) {
            superClasses.add(superClass);
            AdaptableDescriptor.collectSuperTypes(superClass, superClasses, interfaces);
        }
    }
}

