/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.service.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.runtime.model.Adaptable;
import org.nuxeo.runtime.service.AdaptableService;
import org.nuxeo.runtime.service.AdapterManager;
import org.nuxeo.runtime.service.proxy.ServiceAdapterInvoker;
import org.nuxeo.runtime.service.proxy.ServiceProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptableServiceInvoker<T extends AdaptableService>
implements ServiceProxy<T>,
InvocationHandler,
Adaptable {
    protected final T remote;
    protected static final Map<Method, Method> methods = new ConcurrentHashMap<Method, Method>();

    public AdaptableServiceInvoker(T remote) {
        this.remote = remote;
    }

    @Override
    public T getRemote() {
        return this.remote;
    }

    public <A> A getAdapter(Class<A> adapter) {
        A adapterInst = AdapterManager.getInstance().getAdapter(this, adapter);
        if (adapterInst != null) {
            return adapterInst;
        }
        if (this.remote.hasAdapter(adapter)) {
            return this.getAdapterProxy(adapter);
        }
        return null;
    }

    protected <A> A getAdapterProxy(Class<A> adapter) {
        return (A)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{adapter}, (InvocationHandler)new ServiceAdapterInvoker(this));
    }

    protected static void handleException(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method m = methods.get(method);
        if (m == null) {
            try {
                m = this.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                m = method;
            }
            methods.put(method, m);
        }
        try {
            return m.invoke(m == method ? this.remote : this, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                AdaptableServiceInvoker.handleException(cause);
            } else {
                AdaptableServiceInvoker.handleException(e);
            }
            throw e;
        }
        catch (Throwable t) {
            AdaptableServiceInvoker.handleException(t);
            throw t;
        }
    }
}

