/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

public class TabularDataSupport
implements Cloneable,
Map,
Serializable,
TabularData {
    private static final long serialVersionUID = 5720150593236309827L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("dataMap", Map.class), new ObjectStreamField("tabularType", TabularType.class)};
    private Map dataMap;
    private TabularType tabularType;
    private transient String[] indexNames;

    public TabularDataSupport(TabularType tabularType) {
        this(tabularType, 101, 0.75f);
    }

    public TabularDataSupport(TabularType tabularType, int initialCapacity, float loadFactor) {
        this.init(new HashMap(initialCapacity, loadFactor), tabularType);
    }

    public TabularType getTabularType() {
        return this.tabularType;
    }

    public Object[] calculateIndex(CompositeData value) {
        this.validateCompositeData(value);
        return value.getAll(this.indexNames);
    }

    public void clear() {
        this.dataMap.clear();
    }

    public boolean containsKey(Object[] key) {
        if (key == null) {
            return false;
        }
        return this.dataMap.containsKey(Arrays.asList(key));
    }

    public boolean containsValue(CompositeData value) {
        return this.dataMap.containsValue(value);
    }

    public CompositeData get(Object[] key) {
        this.validateKey(key);
        return (CompositeData)this.dataMap.get(Arrays.asList(key));
    }

    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    public Set keySet() {
        return this.dataMap.keySet();
    }

    public void put(CompositeData value) {
        List<Object> index = Arrays.asList(this.calculateIndex(value));
        if (this.dataMap.containsKey(index)) {
            throw new KeyAlreadyExistsException("The index is already used " + index);
        }
        this.dataMap.put(index, value);
    }

    public void putAll(CompositeData[] values) {
        int i;
        if (values == null) {
            return;
        }
        HashSet<List<Object>> keys = new HashSet<List<Object>>();
        for (i = 0; i < values.length; ++i) {
            List<Object> index = Arrays.asList(this.calculateIndex(values[i]));
            if (keys.contains(index)) {
                throw new KeyAlreadyExistsException("Duplicate index in values " + index + " for value " + values[i]);
            }
            keys.add(index);
            if (!this.dataMap.containsKey(index)) continue;
            throw new KeyAlreadyExistsException("Index already used " + index + " for value " + values[i]);
        }
        for (i = 0; i < values.length; ++i) {
            this.put(values[i]);
        }
    }

    public CompositeData remove(Object[] key) {
        this.validateKey(key);
        return (CompositeData)this.dataMap.remove(Arrays.asList(key));
    }

    public int size() {
        return this.dataMap.size();
    }

    public Collection values() {
        return this.dataMap.values();
    }

    public boolean containsKey(Object key) {
        if (key == null || !(key instanceof Object[])) {
            return false;
        }
        return this.containsKey((Object[])key);
    }

    public boolean containsValue(Object value) {
        return this.dataMap.containsValue(value);
    }

    public Set entrySet() {
        return this.dataMap.entrySet();
    }

    public Object get(Object key) {
        return this.get((Object[])key);
    }

    public Object put(Object key, Object value) {
        this.put((CompositeData)value);
        return value;
    }

    public void putAll(Map t) {
        if (t == null) {
            return;
        }
        CompositeData[] data = new CompositeData[t.size()];
        int count = 0;
        Iterator i = t.values().iterator();
        while (i.hasNext()) {
            data[count++] = (CompositeData)i.next();
        }
        this.putAll(data);
    }

    public Object remove(Object key) {
        return this.remove((Object[])key);
    }

    public Object clone() {
        try {
            TabularDataSupport result = (TabularDataSupport)super.clone();
            result.dataMap = (Map)((HashMap)this.dataMap).clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Unexpected clone not supported exception.");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = in.readFields();
        Map dataMap = (Map)getField.get("dataMap", null);
        TabularType tabularType = (TabularType)getField.get("tabularType", null);
        try {
            this.init(dataMap, tabularType);
        }
        catch (Exception e) {
            throw new StreamCorruptedException(e.toString());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TabularData)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        TabularData other = (TabularData)obj;
        if (!this.tabularType.equals(other.getTabularType())) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        Iterator i = this.dataMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object[] indexes = ((List)entry.getKey()).toArray();
            Object thisValue = entry.getValue();
            CompositeData otherValue = other.get(indexes);
            if (thisValue == null && otherValue == null || thisValue != null && thisValue.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.tabularType.hashCode();
        Iterator i = this.dataMap.values().iterator();
        while (i.hasNext()) {
            hash += i.next().hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append(": tabularType=[");
        buffer.append(this.getTabularType());
        buffer.append("] mappings=[");
        Iterator entries = this.dataMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            buffer.append(entry.getKey());
            buffer.append("=");
            buffer.append(entry.getValue());
            if (!entries.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private void init(Map dataMap, TabularType tabularType) {
        if (dataMap == null) {
            throw new IllegalArgumentException("null dataMap");
        }
        if (tabularType == null) {
            throw new IllegalArgumentException("null tabularType");
        }
        this.dataMap = dataMap;
        this.tabularType = tabularType;
        List indexNameList = tabularType.getIndexNames();
        this.indexNames = indexNameList.toArray(new String[indexNameList.size()]);
    }

    private void validateCompositeData(CompositeData value) {
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (!value.getCompositeType().equals(this.tabularType.getRowType())) {
            throw new InvalidOpenTypeException("value has composite type " + value.getCompositeType() + " expected row type " + this.tabularType.getRowType());
        }
    }

    private void validateKey(Object[] key) {
        if (key == null || key.length == 0) {
            throw new NullPointerException("null key");
        }
        if (key.length != this.indexNames.length) {
            throw new InvalidKeyException("key has " + key.length + " elements, " + "should be " + this.indexNames.length);
        }
        for (int i = 0; i < key.length; ++i) {
            OpenType openType = this.tabularType.getRowType().getType(this.indexNames[i]);
            if (key[i] == null || openType.isValue(key[i])) continue;
            throw new InvalidKeyException("key element " + i + " " + key + " is not a value for " + openType);
        }
    }
}

