/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import org.nuxeo.ecm.core.schema.TypeRef;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldImpl
implements Field {
    private static final long serialVersionUID = 1031109949712043501L;
    private QName name;
    private TypeRef<? extends Type> type;
    private TypeRef<? extends Type> declaringType;
    private int flags;
    private int maxOccurs = 1;
    private int minOccurs = 1;
    private String defaultValue;

    public FieldImpl() {
    }

    public FieldImpl(QName name, Type declaringType, Type type) {
        this(name, declaringType.getRef(), type.getRef(), null, 0);
    }

    public FieldImpl(QName name, Type declaringType, Type type, String defaultValue, int flags) {
        this(name, declaringType.getRef(), type.getRef(), defaultValue, flags);
    }

    public FieldImpl(QName name, TypeRef<? extends Type> declaringType, TypeRef<? extends Type> type) {
        this(name, declaringType, type, null, 0);
    }

    public FieldImpl(QName name, TypeRef<? extends Type> declaringType, TypeRef<? extends Type> type, String defaultValue, int flags) {
        this.name = name;
        this.type = type;
        this.declaringType = declaringType;
        this.defaultValue = defaultValue;
        this.flags = flags;
    }

    @Override
    public ComplexType getDeclaringType() {
        return (ComplexType)this.declaringType.get();
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public Type getType() {
        return this.type.get();
    }

    @Override
    public Object getDefaultValue() {
        return this.type.get().decode(this.defaultValue);
    }

    @Override
    public boolean isNillable() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isConstant() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public void setNillable(boolean isNillable) {
        this.flags = isNillable ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    @Override
    public void setConstant(boolean isConstant) {
        this.flags = isConstant ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public void setMaxOccurs(int max) {
        this.maxOccurs = max;
    }

    @Override
    public void setMinOccurs(int min) {
        this.minOccurs = min;
    }

    public String toString() {
        return this.name + " [" + this.type.getName() + ']';
    }
}

