/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.primitives;

import org.nuxeo.ecm.core.schema.types.PrimitiveType;

public final class LongType
extends PrimitiveType {
    public static final String ID = "long";
    public static final LongType INSTANCE = new LongType();
    private static final long serialVersionUID = 5638497847182758981L;

    private LongType() {
        super(ID);
    }

    public boolean validate(Object object) {
        return object instanceof Number;
    }

    public Object convert(Object value) {
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            return Long.parseLong((String)value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Object decode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public String encode(Object object) {
        if (object instanceof Long) {
            return object.toString();
        }
        if (object instanceof Number) {
            return object.toString();
        }
        return object != null ? (String)object : "";
    }

    protected Object readResolve() {
        return INSTANCE;
    }
}

