/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell;

import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.shell.Command;
import org.nuxeo.ecm.shell.CommandDescriptor;
import org.nuxeo.ecm.shell.CommandOption;
import org.nuxeo.ecm.shell.CommandParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="command")
public class DefaultCommandDescriptor
implements CommandDescriptor {
    @XNode(value="@name")
    protected String name;
    @XNode(value="@class")
    protected Class<?> klass;
    protected String[] aliases;
    @XNode(value="description")
    protected String description = "N/A";
    @XNode(value="help")
    protected String help = "N/A";
    @XNodeList(value="options/option", type=CommandOption[].class, componentType=CommandOption.class)
    public CommandOption[] options;
    @XNodeList(value="params/param", type=CommandParameter[].class, componentType=CommandParameter.class)
    public CommandParameter[] params;

    public DefaultCommandDescriptor() {
    }

    public DefaultCommandDescriptor(String name, Class<?> klass) {
        this.name = name;
        this.klass = klass;
    }

    @Override
    public boolean isDynamicScript() {
        return false;
    }

    @Override
    public boolean hasOptions() {
        return this.options != null && this.options.length > 0;
    }

    @Override
    public boolean hasArguments() {
        return this.params != null && this.params.length > 0;
    }

    public String toString() {
        return this.name + " [" + this.klass + ']';
    }

    @XNode(value="@alias")
    void setAlias(String alias) {
        this.aliases = StringUtils.split((String)alias, (char)',', (boolean)true);
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CommandOption[] getOptions() {
        return this.options;
    }

    @Override
    public CommandParameter[] getArguments() {
        return this.params;
    }

    public void setParams(CommandParameter[] params) {
        this.params = params;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public void setOptions(CommandOption[] options) {
        this.options = options;
    }

    @Override
    public int compareTo(CommandDescriptor o) {
        return this.name.compareTo(o.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof DefaultCommandDescriptor)) {
            return false;
        }
        DefaultCommandDescriptor that = (DefaultCommandDescriptor)o;
        return that.name.equals(this.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public Command newInstance() throws Exception {
        if (this.klass != null) {
            return (Command)this.klass.newInstance();
        }
        throw new IllegalStateException("Command implementation not defined : " + this.name);
    }
}

