/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands;

import java.util.List;
import jline.Completor;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.shell.CommandContext;
import org.nuxeo.ecm.shell.CommandLineService;

public class DocumentNameCompletor
implements Completor {
    private final CommandLineService service;

    public DocumentNameCompletor(CommandLineService service) {
        this.service = service;
    }

    public int complete(String buf, int off, List candidates) {
        if (buf == null) {
            buf = "";
        }
        Path path = new Path(buf);
        String prefix = path.lastSegment();
        if (path.hasTrailingSeparator()) {
            prefix = "";
        } else {
            path = path.removeLastSegments(1);
        }
        if (prefix == null) {
            prefix = "";
        }
        try {
            CommandContext context = this.service.getCommandContext();
            DocumentModel parent = context.fetchDocument(path);
            if (!parent.hasFacet("Folderish")) {
                return -1;
            }
            DocumentModelList docs = context.getRepositoryInstance().getChildren(parent.getRef());
            if (buf.length() == 0) {
                for (DocumentModel doc : docs) {
                    candidates.add(doc.getName());
                }
            } else {
                for (DocumentModel doc : docs) {
                    String name = doc.getName();
                    if (!name.startsWith(prefix)) continue;
                    candidates.add(name);
                }
            }
            return buf.length() - prefix.length();
        }
        catch (Exception e) {
            return -1;
        }
    }
}

