/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class ChangeDirCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(ChangeDirCommand.class);

    public void run(CommandLine cmdLine) throws Exception {
        DocumentModel doc;
        String[] elements = cmdLine.getParameters();
        if (elements.length != 1) {
            log.error((Object)(cmdLine.getCommand() + " takes exactly one parameter: the path of the directory to go into"));
        }
        Path path = new Path(elements[0]);
        try {
            doc = this.context.fetchDocument(path);
        }
        catch (Exception e) {
            log.error((Object)"Failed to retrieve the given folder", (Throwable)e);
            return;
        }
        if (doc.hasFacet("Folderish")) {
            this.context.setCurrentDocument(doc);
        } else {
            log.error((Object)("Target document is not a folder but a " + doc.getType()));
        }
    }
}

