/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.search.api.client.IndexingException;
import org.nuxeo.ecm.core.search.api.client.SearchService;
import org.nuxeo.ecm.core.search.api.client.common.SearchServiceDelegate;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class IndexOverloadCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(IndexOverloadCommand.class);

    private void printHelp() {
        System.out.println("");
        System.out.println("Syntax: indexOverLoad doc_path nb [batch_size]");
        System.out.println(" doc_path path of the doc to index");
        System.out.println(" nb number of concurrent indexing job to start");
        System.out.println(" size of indexing batch");
    }

    public void run(CommandLine cmdLine) throws Exception {
        int batchSize;
        String docPath = null;
        int nb = 0;
        String[] elements = cmdLine.getParameters();
        if (elements.length >= 1) {
            if ("help".equals(elements[0])) {
                this.printHelp();
                return;
            }
            docPath = elements[0];
        }
        if (elements.length >= 2) {
            try {
                nb = Integer.parseInt(elements[1]);
            }
            catch (Throwable t) {
                log.error((Object)"Failed to parse nb", t);
                this.printHelp();
                return;
            }
        } else {
            this.printHelp();
            return;
        }
        if (elements.length >= 3) {
            try {
                batchSize = Integer.parseInt(elements[2]);
            }
            catch (Throwable t) {
                log.error((Object)"Failed to parse batch size", t);
                this.printHelp();
                return;
            }
        } else {
            batchSize = -1;
        }
        this.index(docPath, nb, batchSize);
    }

    public void index(String path, int nb, int batchSize) throws Exception {
        SearchService searchService;
        try {
            searchService = SearchServiceDelegate.getRemoteSearchService();
            if (searchService == null) {
                throw new IndexingException("Cannot find search service");
            }
        }
        catch (Exception e) {
            throw new IndexingException("Cannot find search service", (Throwable)e);
        }
        int oldBatchSize = searchService.getIndexingDocBatchSize();
        DocumentModel dm = this.context.getRepositoryInstance().getDocument((DocumentRef)new PathRef(path));
        if (batchSize != -1 && batchSize > 0) {
            searchService.setIndexingDocBatchSize(batchSize);
        }
        if (nb > 100) {
            nb = 100;
            log.info((Object)"Nb of indexing tasks reduced to max queue size (100)");
        }
        log.info((Object)"Sending tasks to search service thread pool");
        for (int i = 0; i < nb; ++i) {
            log.info((Object)"!!! explicit indexing is disabled !!!");
        }
        while (searchService.getActiveIndexingTasks() > 0) {
            Thread.sleep(500L);
            long nbTasksToGo = (long)searchService.getActiveIndexingTasks() + searchService.getIndexingWaitingQueueSize();
            log.info((Object)("still " + nbTasksToGo + " tasks to run"));
        }
        log.info((Object)("Terminated : doc indexed " + nb + " times"));
        searchService.setIndexingDocBatchSize(oldBatchSize);
    }
}

