/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.ColorHelper;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class ListCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(ListCommand.class);

    public void run(CommandLine cmdLine) throws Exception {
        RepositoryInstance repo = this.context.getRepositoryInstance();
        DocumentRef docRef = this.context.getCurrentDocument();
        long t0 = System.currentTimeMillis();
        DocumentModelList docs = repo.getChildren(docRef);
        for (DocumentModel doc : docs) {
            log.info((Object)ColorHelper.decorateName(doc, doc.getName()));
        }
        log.info((Object)(docs.size() + " docs listed in " + (System.currentTimeMillis() - t0) + "ms"));
    }
}

