/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class RmLocalAceCommand
extends AbstractCommand {
    public static final Log log = LogFactory.getLog(RmLocalAceCommand.class);

    public void run(CommandLine cmdLine) throws Exception {
        String[] parameters = cmdLine.getParameters();
        DocumentModel doc = this.context.fetchDocument();
        if (parameters.length != 1) {
            log.error((Object)(cmdLine.getCommand() + " takes exactly 1 parameter: the ace number to be removed (from viewlocalace)."));
            return;
        }
        int aceindex = new Integer(parameters[0]);
        RepositoryInstance session = this.context.getCoreSession();
        this.removeLocalAce((CoreSession)session, doc, aceindex);
        session.save();
    }

    protected void removeLocalAce(CoreSession session, DocumentModel doc, int aceindex) throws Exception {
        ACP acp = session.getACP(doc.getRef());
        ACL acl = acp.getACL("local");
        if (acl == null) {
            log.warn((Object)"No local acl for the current document");
            return;
        }
        ACE[] aces = acl.getACEs();
        if (aces.length < aceindex) {
            log.error((Object)("aceindex can't be greater than the number of aces: " + aces.length));
            return;
        }
        acl.remove(aceindex);
        session.setACP(doc.getRef(), acp, true);
    }
}

