/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.nuxeo.ecm.shell.CommandDescriptor;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;
import org.nuxeo.ecm.shell.header.CommandHeader;
import org.nuxeo.ecm.shell.header.GroovyHeaderExtractor;
import org.nuxeo.ecm.shell.header.HeaderExtractor;
import org.nuxeo.ecm.shell.header.PyHeaderExtractor;

public class ScriptingCommand
extends AbstractCommand {
    protected static final ScriptEngineManager scriptMgr = new ScriptEngineManager();
    protected static final Map<String, HeaderExtractor> extractors = new HashMap<String, HeaderExtractor>();
    protected final CommandDescriptor descriptor;
    protected CompiledScript script;
    protected final File file;
    protected long lastModified = 0L;
    protected CommandHeader header;

    public ScriptingCommand(CommandDescriptor descriptor, File file) {
        this.descriptor = descriptor;
        this.file = file;
        this.lastModified = file.lastModified();
    }

    public CommandHeader getCommandHeader() throws Exception {
        this.getScript();
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CommandLine cmdLine) throws Exception {
        this.getScript();
        SimpleBindings ctx = new SimpleBindings();
        ctx.put("cmdLine", (Object)cmdLine);
        ctx.put("ctx", (Object)this.context);
        ctx.put("client", (Object)this.client);
        ctx.put("service", (Object)this.cmdService);
        try {
            this.script.eval(ctx);
        }
        finally {
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompiledScript compileScript(ScriptEngine engine, File file) throws ScriptException {
        if (engine instanceof Compilable) {
            CompiledScript compiledScript;
            Compilable comp = (Compilable)((Object)engine);
            FileReader reader = new FileReader(file);
            try {
                compiledScript = comp.compile(reader);
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ScriptException(e);
                }
            }
            ((Reader)reader).close();
            return compiledScript;
        }
        return null;
    }

    public static String getExtension(File file) {
        String name = file.getName();
        int p = name.lastIndexOf(46);
        if (p > -1) {
            return name.substring(p + 1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledScript getScript() throws ScriptException, IOException, ParseException {
        if (this.file.lastModified() > this.lastModified) {
            this.script = null;
        }
        if (this.script == null) {
            String ext = ScriptingCommand.getExtension(this.file);
            ScriptEngine engine = scriptMgr.getEngineByExtension(ext);
            this.script = ScriptingCommand.compileScript(engine, this.file);
            HeaderExtractor extractor = extractors.get(ext);
            if (extractor != null) {
                FileReader reader = new FileReader(this.file);
                try {
                    this.header = extractor.extractHeader(reader);
                }
                finally {
                    reader.close();
                }
            }
        }
        return this.script;
    }

    static {
        extractors.put("groovy", new GroovyHeaderExtractor());
        extractors.put("py", new PyHeaderExtractor());
    }
}

