/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.api;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.MapKey;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="LogEntry")
@NamedQueries(value={@NamedQuery(name="LogEntry.removeByEventIdAndPath", query="delete LogEntry log where log.eventId = :eventId and log.docPath like :pathPattern"), @NamedQuery(name="LogEntry.findByDocument", query="from LogEntry log where log.docUUID=:docUUID ORDER BY log.eventDate DESC"), @NamedQuery(name="LogEntry.findAll", query="from LogEntry log order by log.eventDate DESC"), @NamedQuery(name="LogEntry.findByEventIdAndPath", query="from LogEntry log where log.eventId=:eventId and log.docPath LIKE :pathPattern"), @NamedQuery(name="LogEntry.findByHavingExtendedInfo", query="from LogEntry log where log.extendedInfos['one'] is not null order by log.eventDate DESC"), @NamedQuery(name="LogEntry.countEventsById", query="select count(log.eventId) from LogEntry log where log.eventId=:eventId"), @NamedQuery(name="LogEntry.findEventIds", query="select distinct log.eventId from LogEntry log")})
@Table(name="NXP_LOGS")
public class LogEntry
implements Serializable {
    private static final long serialVersionUID = 3037187381843636097L;
    private long id;
    private String principalName;
    private String eventId;
    private Date eventDate;
    private String docUUID;
    private String docType;
    private String docPath;
    private String category;
    private String comment;
    private String docLifeCycle;
    private Map<String, ExtendedInfo> extendedInfos = new HashMap<String, ExtendedInfo>();

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="LOG_ID", nullable=false, columnDefinition="integer")
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Column(name="LOG_PRINCIPAL_NAME")
    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    @Column(name="LOG_EVENT_ID", nullable=false)
    @javax.persistence.MapKey(name="logKey")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="LOG_EVENT_DATE")
    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    @Column(name="LOG_DOC_UUID")
    public String getDocUUID() {
        return this.docUUID;
    }

    public void setDocUUID(String docUUID) {
        this.docUUID = docUUID;
    }

    public void setDocUUID(DocumentRef docRef) {
        if (docRef.type() != 1) {
            throw new IllegalArgumentException("not an id reference " + docRef);
        }
        this.docUUID = (String)docRef.reference();
    }

    @Column(name="LOG_DOC_PATH", length=1024)
    public String getDocPath() {
        return this.docPath;
    }

    public void setDocPath(String docPath) {
        this.docPath = docPath;
    }

    @Column(name="LOG_DOC_TYPE")
    public String getDocType() {
        return this.docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    @Column(name="LOG_EVENT_CATEGORY")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Column(name="LOG_EVENT_COMMENT", length=1024)
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name="LOG_DOC_LIFE_CYCLE")
    public String getDocLifeCycle() {
        return this.docLifeCycle;
    }

    public void setDocLifeCycle(String docLifeCycle) {
        this.docLifeCycle = docLifeCycle;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="NXP_LOGS_MAPEXTINFOS", joinColumns={@JoinColumn(name="LOG_FK")}, inverseJoinColumns={@JoinColumn(name="INFO_FK")})
    @MapKey(columns={@Column(name="mapkey", nullable=false)})
    public Map<String, ExtendedInfo> getExtendedInfos() {
        return this.extendedInfos;
    }

    public void setExtendedInfos(Map<String, ExtendedInfo> infos) {
        this.extendedInfos = infos;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

