/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.Invoker;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.loading.ClassByteClassLoader;
import org.jboss.remoting.marshal.MarshallLoaderFactory;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.socketfactory.CreationListenerSocketFactory;
import org.jboss.remoting.socketfactory.SocketCreationListener;
import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
import org.jboss.util.id.GUID;

public abstract class AbstractInvoker
implements Invoker {
    protected static final Logger log = Logger.getLogger(AbstractInvoker.class);
    protected ClassByteClassLoader classbyteloader;
    protected InvokerLocator locator;
    protected Map localServerLocators = new HashMap();
    protected String serializationType;
    protected Map configuration = new HashMap();
    protected SocketFactory socketFactory;
    protected boolean socketFactoryCreatedFromSSLParameters;

    public AbstractInvoker(InvokerLocator locator) {
        this(locator, null);
    }

    public AbstractInvoker(InvokerLocator locator, Map configuration) {
        this.classbyteloader = new ClassByteClassLoader(this.getClass().getClassLoader());
        this.locator = locator;
        if (configuration != null) {
            this.configuration.putAll(configuration);
        }
        if (locator.getParameters() != null) {
            this.configuration.putAll(locator.getParameters());
        }
        try {
            InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
            if (loaderLocator != null) {
                this.classbyteloader.setClientInvoker(new Client(loaderLocator));
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not create remote class loading for invoker.", (Throwable)e);
        }
        if (locator == null || locator.getParameters() == null) {
            this.setSerializationType("java");
        } else {
            this.setSerializationType(locator.findSerializationType());
        }
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addClientLocator(String sessionId, InvokerCallbackHandler callbackhandler, InvokerLocator locator) {
        String listenerId = null;
        Map map = this.localServerLocators;
        synchronized (map) {
            CallbackHandlerHolder holder2;
            Collection holders = this.localServerLocators.values();
            for (CallbackHandlerHolder holder2 : holders) {
                InvokerCallbackHandler holderhandler = holder2.getHandler();
                boolean handlersEqual = holderhandler.equals(callbackhandler);
                InvokerLocator handlerLocator = holder2.getLocator();
                boolean locatorsEqual = handlerLocator.equals(locator);
                if (!handlersEqual || !locatorsEqual) continue;
                return null;
            }
            holder2 = new CallbackHandlerHolder(callbackhandler, locator);
            String key = listenerId = new GUID().toString();
            if (sessionId != null) {
                key = sessionId + "+" + listenerId;
            }
            this.localServerLocators.put(key, holder2);
        }
        return listenerId;
    }

    public InvokerLocator getClientLocator(String listenerId) {
        CallbackHandlerHolder holder;
        InvokerLocator locator = null;
        if (listenerId != null && (holder = (CallbackHandlerHolder)this.localServerLocators.get(listenerId)) != null) {
            locator = holder.getLocator();
        }
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getClientLocators(String sessionId, InvokerCallbackHandler handler) {
        ArrayList<CallbackLocatorHolder> holderList = new ArrayList<CallbackLocatorHolder>();
        if (handler != null) {
            Map map = this.localServerLocators;
            synchronized (map) {
                String listenerId;
                Set entries = this.localServerLocators.entrySet();
                for (Map.Entry entry : entries) {
                    CallbackHandlerHolder holder;
                    InvokerCallbackHandler holderHandler;
                    int index;
                    listenerId = (String)entry.getKey();
                    String prefix = listenerId.substring(0, index = listenerId.indexOf(43));
                    if (!sessionId.equals(prefix)) continue;
                    if (index >= 0) {
                        listenerId = listenerId.substring(index + 1);
                    }
                    if (!(holderHandler = (holder = (CallbackHandlerHolder)entry.getValue()).getHandler()).equals(handler)) continue;
                    CallbackLocatorHolder locatorHolder = new CallbackLocatorHolder(listenerId, holder.getLocator());
                    holderList.add(locatorHolder);
                }
                if (holderList.size() > 0) {
                    for (int x = 0; x < holderList.size(); ++x) {
                        listenerId = ((CallbackLocatorHolder)holderList.get(x)).getListenerId();
                        String key = sessionId + "+" + listenerId;
                        this.localServerLocators.remove(key);
                    }
                }
            }
        }
        return holderList;
    }

    public synchronized void setClassLoader(ClassLoader classloader) {
        this.classbyteloader = new ClassByteClassLoader(classloader);
    }

    public synchronized ClassLoader getClassLoader() {
        return this.classbyteloader;
    }

    public String getSerializationType() {
        return this.serializationType;
    }

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public boolean isSocketFactoryCreatedFromSSLParameters() {
        return this.socketFactoryCreatedFromSSLParameters;
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        String socketFactoryString;
        if (configuration == null) {
            return null;
        }
        if (this.socketFactory != null) {
            return this.socketFactory;
        }
        SocketFactory factory = null;
        Object obj = configuration.get("customSocketFactory");
        if (obj != null) {
            if (obj instanceof SocketFactory) {
                factory = (SocketFactory)obj;
            } else {
                throw new RuntimeException("Can not set custom socket factory (" + obj + ") as is not of type javax.net.SocketFactory");
            }
        }
        if (factory == null && (socketFactoryString = (String)configuration.get("socketFactory")) != null && socketFactoryString.length() > 0) {
            try {
                Class cl = ClassLoaderUtility.loadClass(socketFactoryString, this.getClass());
                Constructor socketFactoryConstructor = null;
                socketFactoryConstructor = cl.getConstructor(new Class[0]);
                factory = (SocketFactory)socketFactoryConstructor.newInstance(new Object[0]);
                log.trace((Object)("SocketFactory (" + socketFactoryString + ") loaded"));
            }
            catch (Exception e) {
                log.debug((Object)("Could not create socket factory by classname (" + socketFactoryString + ").  Error message: " + e.getMessage()));
            }
        }
        if (factory == null && AbstractInvoker.needsCustomSSLConfiguration(configuration)) {
            try {
                SSLSocketBuilder socketBuilder = new SSLSocketBuilder(configuration);
                socketBuilder.setUseSSLSocketFactory(false);
                factory = socketBuilder.createSSLSocketFactory();
                this.socketFactoryCreatedFromSSLParameters = true;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create customized SSL socket factory", e);
            }
        }
        return AbstractInvoker.wrapSocketFactory(factory, configuration);
    }

    public static SocketFactory wrapSocketFactory(SocketFactory socketFactory, Map config) {
        if (config == null) {
            return socketFactory;
        }
        Object o = config.get("socketCreationClientListener");
        if (o == null) {
            return socketFactory;
        }
        if (o instanceof SocketCreationListener) {
            SocketCreationListener listener = (SocketCreationListener)o;
            return new CreationListenerSocketFactory(socketFactory, listener);
        }
        if (o instanceof String) {
            try {
                Class c = ClassLoaderUtility.loadClass((String)o, AbstractInvoker.class);
                SocketCreationListener listener = (SocketCreationListener)c.newInstance();
                return new CreationListenerSocketFactory(socketFactory, listener);
            }
            catch (Exception e) {
                log.error((Object)("unable to instantiate class: " + o), (Throwable)e);
                return socketFactory;
            }
        }
        log.error((Object)("unrecognized type for socket creation client listener: " + o));
        return socketFactory;
    }

    public static boolean isCompleteSocketFactory(SocketFactory sf) {
        return sf != null && (!(sf instanceof SocketFactoryWrapper) || ((SocketFactoryWrapper)((Object)sf)).getSocketFactory() != null);
    }

    public static boolean needsCustomSSLConfiguration(Map configuration) {
        return configuration.get("org.jboss.remoting.keyAlias") != null || configuration.get("org.jboss.remoting.clientAuthMode") != null || configuration.get("org.jboss.remoting.serverAuthMode") != null || configuration.get("org.jboss.remoting.sslProtocol") != null || configuration.get("org.jboss.remoting.sslProviderName") != null || configuration.get("org.jboss.remoting.serversocket.useClientMode") != null || configuration.get("org.jboss.remoting.socket.useClientMode") != null || configuration.get("org.jboss.remoting.keyPassword") != null || configuration.get("org.jboss.remoting.keyStoreAlgorithm") != null || configuration.get("org.jboss.remoting.keyStore") != null || configuration.get("org.jboss.remoting.keyStorePassword") != null || configuration.get("org.jboss.remoting.keyStoreType") != null || configuration.get("org.jboss.remoting.trustStoreAlgorithm") != null || configuration.get("org.jboss.remoting.trustStore") != null || configuration.get("org.jboss.remoting.trustStorePassword") != null || configuration.get("org.jboss.remoting.trustStoreType") != null;
    }

    public class CallbackLocatorHolder {
        private InvokerLocator locator;
        private String listenerId;

        public CallbackLocatorHolder(String listenerId, InvokerLocator locator) {
            this.listenerId = listenerId;
            this.locator = locator;
        }

        public String getListenerId() {
            return this.listenerId;
        }

        public InvokerLocator getLocator() {
            return this.locator;
        }
    }

    private class CallbackHandlerHolder {
        private InvokerCallbackHandler handler;
        private InvokerLocator locator;

        private CallbackHandlerHolder(InvokerCallbackHandler handler, InvokerLocator locator) {
            this.handler = handler;
            this.locator = locator;
        }

        public InvokerCallbackHandler getHandler() {
            return this.handler;
        }

        public InvokerLocator getLocator() {
            return this.locator;
        }
    }
}

