/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.callback.acknowledgement;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;

public class CallbackAcknowledgeClient {
    private static String transport = "socket";
    private static String host;
    private static int port;
    private Client client;

    public static void main(String[] args) {
        if (args != null && args.length == 2) {
            transport = args[0];
            port = Integer.parseInt(args[1]);
        }
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e1) {
            System.err.println("cannot get local host name");
            return;
        }
        String locatorURI = transport + "://" + host + ":" + port;
        CallbackAcknowledgeClient acknowledgeClient = new CallbackAcknowledgeClient();
        try {
            acknowledgeClient.createRemotingClient(locatorURI);
            acknowledgeClient.testPullCallbackAcknowledgements();
            acknowledgeClient.testPolledCallbackApplicationAcknowledgements();
            acknowledgeClient.testPolledCallbackRemotingAcknowledgements();
            acknowledgeClient.testPushCallbackApplicationAcknowledgements();
            acknowledgeClient.testPushCallbackRemotingAcknowledgements();
            acknowledgeClient.disconnectRemotingClient();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.out.println("done.");
    }

    public void createRemotingClient(String locatorURI) throws Exception {
        this.client = new Client(new InvokerLocator(locatorURI));
        this.client.connect();
    }

    public void disconnectRemotingClient() {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    public void testPullCallbackAcknowledgements() {
        try {
            NonAcknowledgingCallbackHandler callbackHandler = new NonAcknowledgingCallbackHandler();
            this.client.addListener(callbackHandler);
            this.client.invoke("applicationAcknowledgements");
            List callbacks = this.client.getCallbacks(callbackHandler);
            ArrayList<String> responses = new ArrayList<String>(callbacks.size());
            for (Callback callback : callbacks) {
                System.out.println("received pull callback: " + callback.getParameter());
                responses.add(callback.getParameter() + ": acknowledged");
            }
            this.client.acknowledgeCallbacks(callbackHandler, callbacks, responses);
            this.client.removeListener(callbackHandler);
        }
        catch (Throwable e) {
            System.out.println("failure: " + e.getMessage());
        }
    }

    public void testPolledCallbackApplicationAcknowledgements() {
        try {
            AcknowledgingCallbackHandler callbackHandler = new AcknowledgingCallbackHandler(this.client);
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("callbackPollPeriod", "1000");
            this.client.addListener((InvokerCallbackHandler)callbackHandler, metadata);
            this.client.invoke("applicationAcknowledgements");
            Thread.sleep(2000L);
            this.client.removeListener(callbackHandler);
        }
        catch (Throwable e) {
            System.out.println("failure: " + e.getMessage());
        }
    }

    public void testPolledCallbackRemotingAcknowledgements() {
        try {
            NonAcknowledgingCallbackHandler callbackHandler = new NonAcknowledgingCallbackHandler();
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("callbackPollPeriod", "1000");
            this.client.addListener((InvokerCallbackHandler)callbackHandler, metadata);
            this.client.invoke("remotingAcknowledgements");
            Thread.sleep(2000L);
            this.client.removeListener(callbackHandler);
        }
        catch (Throwable e) {
            System.out.println("failure: " + e.getMessage());
        }
    }

    public void testPushCallbackApplicationAcknowledgements() {
        try {
            AcknowledgingCallbackHandler callbackHandler = new AcknowledgingCallbackHandler(this.client);
            this.client.addListener(callbackHandler, null, null, true);
            this.client.invoke("applicationAcknowledgements");
            this.client.removeListener(callbackHandler);
        }
        catch (Throwable e) {
            System.out.println("failure: " + e.getMessage());
        }
    }

    public void testPushCallbackRemotingAcknowledgements() {
        try {
            NonAcknowledgingCallbackHandler callbackHandler = new NonAcknowledgingCallbackHandler();
            this.client.addListener(callbackHandler, null, null, true);
            this.client.invoke("remotingAcknowledgements");
            this.client.removeListener(callbackHandler);
        }
        catch (Throwable e) {
            System.out.println("failure: " + e.getMessage());
        }
    }

    static {
        port = 5401;
    }

    static class AcknowledgingCallbackHandler
    implements InvokerCallbackHandler {
        private Client client;

        public AcknowledgingCallbackHandler(Client client) {
            this.client = client;
        }

        public void handleCallback(Callback callback) throws HandleCallbackException {
            System.out.println("received push callback: " + callback.getParameter());
            String response = callback.getParameter() + ": acknowledged";
            try {
                this.client.acknowledgeCallback(this, callback, response);
            }
            catch (Throwable e) {
                System.out.println("Unable to acknowledge callback: " + callback.getParameter());
            }
        }
    }

    static class NonAcknowledgingCallbackHandler
    implements InvokerCallbackHandler {
        NonAcknowledgingCallbackHandler() {
        }

        public void handleCallback(Callback callback) throws HandleCallbackException {
            System.out.println("received push callback: " + callback.getParameter());
        }
    }
}

