/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.sslmultiplex;

import java.io.IOException;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.CustomSSLServerSocketFactory;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.security.SSLSocketBuilderMBean;
import org.jboss.remoting.transport.multiplex.MultiplexServerInvoker;

public class SSLMultiplexServerInvoker
extends MultiplexServerInvoker {
    public SSLMultiplexServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public SSLMultiplexServerInvoker(InvokerLocator locator, Map configuration) throws IOException {
        super(locator, configuration);
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        SocketFactory socketFactory = null;
        socketFactory = super.createSocketFactory(configuration);
        if (socketFactory != null) {
            return socketFactory;
        }
        ServerSocketFactory serverSocketFactory = this.getServerSocketFactory();
        try {
            if (serverSocketFactory instanceof CustomSSLServerSocketFactory) {
                CustomSSLServerSocketFactory customServerSocketFactory = (CustomSSLServerSocketFactory)serverSocketFactory;
                SSLSocketBuilderMBean builder = customServerSocketFactory.getSSLSocketBuilder();
                boolean shouldUseDefault = builder.getUseSSLServerSocketFactory();
                builder.setUseSSLSocketFactory(shouldUseDefault);
                boolean useClientMode = builder.isServerSocketUseClientMode();
                builder.setSocketUseClientMode(useClientMode);
                return builder.createSSLSocketFactory();
            }
            SSLSocketBuilder builder = new SSLSocketBuilder(configuration);
            return builder.createSSLSocketFactory();
        }
        catch (Exception e) {
            log.error((Object)"Error creating SSL Socket Factory for server invoker.", (Throwable)e);
            return null;
        }
    }

    protected ServerSocketFactory getDefaultServerSocketFactory() {
        return SSLServerSocketFactory.getDefault();
    }
}

