/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Locale;
import java.util.Random;
import jregex.Matcher;
import jregex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.Pack;
import org.jruby.util.Sprintf;

public class RubyString
extends RubyObject {
    private static final String DEFAULT_RS = "\n";
    private static final int SHARE_LEVEL_NONE = 0;
    private static final int SHARE_LEVEL_BYTELIST = 1;
    private static final int SHARE_LEVEL_BUFFER = 2;
    private ByteList value;
    private int shareLevel = 0;
    private static ObjectAllocator STRING_ALLOCATOR;
    public static final byte OP_PLUS_SWITCHVALUE = 1;
    public static final byte OP_LT_SWITCHVALUE = 2;
    public static final byte AREF_SWITCHVALUE = 3;
    public static final byte ASET_SWITCHVALUE = 4;
    public static final byte NIL_P_SWITCHVALUE = 5;
    public static final byte EQUALEQUAL_SWITCHVALUE = 6;
    public static final byte OP_GE_SWITCHVALUE = 7;
    public static final byte OP_LSHIFT_SWITCHVALUE = 8;
    public static final byte EMPTY_P_SWITCHVALUE = 9;
    public static final byte TO_S_SWITCHVALUE = 10;
    public static final byte TO_I_SWITCHVALUE = 11;
    public static final byte TO_STR_SWITCHVALUE = 12;
    public static final byte TO_SYM_SWITCHVALUE = 13;
    public static final byte HASH_SWITCHVALUE = 14;
    public static final byte OP_GT_SWITCHVALUE = 15;
    public static final byte OP_TIMES_SWITCHVALUE = 16;
    public static final byte OP_LE_SWITCHVALUE = 17;
    public static final byte OP_SPACESHIP_SWITCHVALUE = 18;
    public static final byte LENGTH_SWITCHVALUE = 19;
    public static final byte MATCH_SWITCHVALUE = 20;
    public static final byte EQQ_SWITCHVALUE = 21;
    public static final byte INSPECT_SWITCHVALUE = 22;
    private static final ByteList SPACE_BYTELIST;
    private static final boolean[] WHITESPACE;
    private static final int TRANS_SIZE = 256;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static RubyClass createStringClass(Ruby runtime) {
        RubyClass stringClass = runtime.defineClass("String", runtime.getObject(), STRING_ALLOCATOR);
        stringClass.index = 4;
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyString.class);
        stringClass.includeModule(runtime.getModule("Comparable"));
        stringClass.includeModule(runtime.getModule("Enumerable"));
        stringClass.defineFastMethod("<=>", callbackFactory.getFastMethod("op_cmp", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("==", callbackFactory.getFastMethod("equal", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("+", callbackFactory.getFastMethod("op_plus", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("*", callbackFactory.getFastMethod("op_mul", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("%", callbackFactory.getFastMethod("format", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        stringClass.defineFastMethod(">=", callbackFactory.getFastMethod("op_ge", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod(">", callbackFactory.getFastMethod("op_gt", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("<=", callbackFactory.getFastMethod("op_le", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("<", callbackFactory.getFastMethod("op_lt", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("eql?", callbackFactory.getFastMethod("eql_p", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("[]", callbackFactory.getFastOptMethod("aref"));
        stringClass.defineFastMethod("[]=", callbackFactory.getFastOptMethod("aset"));
        stringClass.defineFastMethod("=~", callbackFactory.getFastMethod("match", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("~", callbackFactory.getFastMethod("match2"));
        stringClass.defineFastMethod("capitalize", callbackFactory.getFastMethod("capitalize"));
        stringClass.defineFastMethod("capitalize!", callbackFactory.getFastMethod("capitalize_bang"));
        stringClass.defineFastMethod("casecmp", callbackFactory.getFastMethod("casecmp", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("center", callbackFactory.getFastOptMethod("center"));
        stringClass.defineFastMethod("chop", callbackFactory.getFastMethod("chop"));
        stringClass.defineFastMethod("chop!", callbackFactory.getFastMethod("chop_bang"));
        stringClass.defineFastMethod("chomp", callbackFactory.getFastOptMethod("chomp"));
        stringClass.defineFastMethod("chomp!", callbackFactory.getFastOptMethod("chomp_bang"));
        stringClass.defineFastMethod("concat", callbackFactory.getFastMethod("concat", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("count", callbackFactory.getFastOptMethod("count"));
        stringClass.defineFastMethod("crypt", callbackFactory.getFastMethod("crypt", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("delete", callbackFactory.getFastOptMethod("delete"));
        stringClass.defineFastMethod("delete!", callbackFactory.getFastOptMethod("delete_bang"));
        stringClass.defineFastMethod("downcase", callbackFactory.getFastMethod("downcase"));
        stringClass.defineFastMethod("downcase!", callbackFactory.getFastMethod("downcase_bang"));
        stringClass.defineFastMethod("dump", callbackFactory.getFastMethod("dump"));
        stringClass.defineMethod("each_line", callbackFactory.getOptMethod("each_line"));
        stringClass.defineMethod("each_byte", callbackFactory.getMethod("each_byte"));
        stringClass.defineFastMethod("empty?", callbackFactory.getFastMethod("empty"));
        stringClass.defineMethod("gsub", callbackFactory.getOptMethod("gsub"));
        stringClass.defineMethod("gsub!", callbackFactory.getOptMethod("gsub_bang"));
        stringClass.defineFastMethod("hex", callbackFactory.getFastMethod("hex"));
        stringClass.defineFastMethod("include?", callbackFactory.getFastMethod("include", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("index", callbackFactory.getFastOptMethod("index"));
        stringClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        stringClass.defineFastMethod("initialize_copy", callbackFactory.getFastMethod("replace", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("insert", callbackFactory.getFastMethod("insert", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        stringClass.defineFastMethod("length", callbackFactory.getFastMethod("length"));
        stringClass.defineFastMethod("ljust", callbackFactory.getFastOptMethod("ljust"));
        stringClass.defineFastMethod("lstrip", callbackFactory.getFastMethod("lstrip"));
        stringClass.defineFastMethod("lstrip!", callbackFactory.getFastMethod("lstrip_bang"));
        stringClass.defineFastMethod("match", callbackFactory.getFastMethod("match3", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("oct", callbackFactory.getFastMethod("oct"));
        stringClass.defineFastMethod("replace", callbackFactory.getFastMethod("replace", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("reverse", callbackFactory.getFastMethod("reverse"));
        stringClass.defineFastMethod("reverse!", callbackFactory.getFastMethod("reverse_bang"));
        stringClass.defineFastMethod("rindex", callbackFactory.getFastOptMethod("rindex"));
        stringClass.defineFastMethod("rjust", callbackFactory.getFastOptMethod("rjust"));
        stringClass.defineFastMethod("rstrip", callbackFactory.getFastMethod("rstrip"));
        stringClass.defineFastMethod("rstrip!", callbackFactory.getFastMethod("rstrip_bang"));
        stringClass.defineMethod("scan", callbackFactory.getMethod("scan", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("slice!", callbackFactory.getFastOptMethod("slice_bang"));
        stringClass.defineFastMethod("split", callbackFactory.getFastOptMethod("split"));
        stringClass.defineFastMethod("strip", callbackFactory.getFastMethod("strip"));
        stringClass.defineFastMethod("strip!", callbackFactory.getFastMethod("strip_bang"));
        stringClass.defineFastMethod("succ", callbackFactory.getFastMethod("succ"));
        stringClass.defineFastMethod("succ!", callbackFactory.getFastMethod("succ_bang"));
        stringClass.defineFastMethod("squeeze", callbackFactory.getFastOptMethod("squeeze"));
        stringClass.defineFastMethod("squeeze!", callbackFactory.getFastOptMethod("squeeze_bang"));
        stringClass.defineMethod("sub", callbackFactory.getOptMethod("sub"));
        stringClass.defineMethod("sub!", callbackFactory.getOptMethod("sub_bang"));
        stringClass.defineFastMethod("sum", callbackFactory.getFastOptMethod("sum"));
        stringClass.defineFastMethod("swapcase", callbackFactory.getFastMethod("swapcase"));
        stringClass.defineFastMethod("swapcase!", callbackFactory.getFastMethod("swapcase_bang"));
        stringClass.defineFastMethod("to_f", callbackFactory.getFastMethod("to_f"));
        stringClass.defineFastMethod("to_i", callbackFactory.getFastOptMethod("to_i"));
        stringClass.defineFastMethod("to_str", callbackFactory.getFastMethod("to_s"));
        stringClass.defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        stringClass.defineFastMethod("to_sym", callbackFactory.getFastMethod("to_sym"));
        stringClass.defineFastMethod("tr", callbackFactory.getFastMethod("tr", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("tr!", callbackFactory.getFastMethod("tr_bang", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("tr_s", callbackFactory.getFastMethod("tr_s", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("tr_s!", callbackFactory.getFastMethod("tr_s_bang", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("unpack", callbackFactory.getFastMethod("unpack", RubyKernel.IRUBY_OBJECT));
        stringClass.defineFastMethod("upcase", callbackFactory.getFastMethod("upcase"));
        stringClass.defineFastMethod("upcase!", callbackFactory.getFastMethod("upcase_bang"));
        stringClass.defineMethod("upto", callbackFactory.getMethod("upto", RubyKernel.IRUBY_OBJECT));
        stringClass.defineAlias("<<", "concat");
        stringClass.defineAlias("each", "each_line");
        stringClass.defineAlias("intern", "to_sym");
        stringClass.defineAlias("next", "succ");
        stringClass.defineAlias("next!", "succ!");
        stringClass.defineAlias("size", "length");
        stringClass.defineAlias("slice", "[]");
        return stringClass;
    }

    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        switch (this.getRuntime().getSelectorTable().table[rubyclass.index][methodIndex]) {
            case 1: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_plus(args[0]);
            }
            case 2: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_lt(args[0]);
            }
            case 3: {
                return this.aref(args);
            }
            case 4: {
                return this.aset(args);
            }
            case 5: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.nil_p();
            }
            case 6: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.equal(args[0]);
            }
            case 7: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_ge(args[0]);
            }
            case 8: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.concat(args[0]);
            }
            case 9: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.empty();
            }
            case 10: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_s();
            }
            case 11: {
                return this.to_i(args);
            }
            case 12: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_s();
            }
            case 13: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_sym();
            }
            case 14: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.hash();
            }
            case 15: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_gt(args[0]);
            }
            case 16: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_mul(args[0]);
            }
            case 17: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_le(args[0]);
            }
            case 18: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_cmp(args[0]);
            }
            case 19: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.length();
            }
            case 20: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.match(args[0]);
            }
            case 21: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.equal(args[0]);
            }
            case 22: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.inspect();
            }
        }
        return super.callMethod(context, rubyclass, name, args, callType, block);
    }

    public final boolean eql(IRubyObject other) {
        return other instanceof RubyString && this.value.equal(((RubyString)other).value);
    }

    private RubyString(Ruby runtime, CharSequence value) {
        this(runtime, runtime.getString(), value);
    }

    private RubyString(Ruby runtime, byte[] value) {
        this(runtime, runtime.getString(), value);
    }

    private RubyString(Ruby runtime, ByteList value) {
        this(runtime, runtime.getString(), value);
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, CharSequence value) {
        super(runtime, rubyClass);
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        this.value = new ByteList(ByteList.plain(value), false);
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, byte[] value) {
        super(runtime, rubyClass);
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        this.value = new ByteList(value);
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, ByteList value) {
        super(runtime, rubyClass);
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        this.value = value;
    }

    public int getNativeTypeIndex() {
        return 4;
    }

    public Class getJavaClass() {
        return String.class;
    }

    public RubyString convertToString() {
        return this;
    }

    public String toString() {
        return this.value.toString();
    }

    public final RubyString strDup() {
        return this.strDup(this.getMetaClass());
    }

    private final RubyString strDup(RubyClass clazz) {
        this.shareLevel = 1;
        RubyString dup = new RubyString(this.getRuntime(), clazz, this.value);
        dup.shareLevel = 1;
        dup.infectBy(this);
        return dup;
    }

    public final RubyString makeShared(int index, int len) {
        if (len == 0) {
            return RubyString.newEmptyString(this.getRuntime(), this.getMetaClass());
        }
        if (this.shareLevel == 0) {
            this.shareLevel = 2;
        }
        RubyString shared = new RubyString(this.getRuntime(), this.getMetaClass(), this.value.makeShared(index, len));
        shared.shareLevel = 2;
        shared.infectBy(this);
        return shared;
    }

    private final void modifyCheck() {
        this.testFrozen("string");
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify string");
        }
    }

    private final void modifyCheck(byte[] b, int len) {
        if (this.value.bytes != b || this.value.realSize != len) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private final void frozenCheck() {
        if (this.isFrozen()) {
            throw this.getRuntime().newRuntimeError("string frozen");
        }
    }

    public final void modify() {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 1) {
                this.value = this.value.dup();
            } else if (this.shareLevel == 2) {
                this.value.unshare();
            }
            this.shareLevel = 0;
        }
        this.value.invalidate();
    }

    public final void modify(int length) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 1) {
                this.value = this.value.dup(length);
            } else if (this.shareLevel == 2) {
                this.value.unshare(length);
            }
            this.shareLevel = 0;
        } else {
            this.value = this.value.dup(length);
        }
        this.value.invalidate();
    }

    private final void view(ByteList bytes) {
        this.modifyCheck();
        this.value = bytes;
        this.shareLevel = 0;
    }

    private final void view(byte[] bytes) {
        this.modifyCheck();
        this.value.replace(bytes);
        this.shareLevel = 0;
        this.value.invalidate();
    }

    private final void view(int index, int len) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 1) {
                this.value = this.value.makeShared(index, len);
                this.shareLevel = 2;
            } else if (this.shareLevel == 2) {
                this.value.view(index, len);
            }
        } else {
            this.value.view(index, len);
            this.shareLevel = 2;
        }
        this.value.invalidate();
    }

    public static String bytesToString(byte[] bytes, int beg, int len) {
        return new String(ByteList.plain(bytes, beg, len));
    }

    public static String byteListToString(ByteList bytes) {
        return RubyString.bytesToString(bytes.unsafeBytes(), bytes.begin(), bytes.length());
    }

    public static String bytesToString(byte[] bytes) {
        return RubyString.bytesToString(bytes, 0, bytes.length);
    }

    public static byte[] stringToBytes(String string) {
        return ByteList.plain(string);
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isUpper(int c) {
        return c >= 65 && c <= 90;
    }

    public static boolean isLower(int c) {
        return c >= 97 && c <= 122;
    }

    public static boolean isLetter(int c) {
        return RubyString.isUpper(c) || RubyString.isLower(c);
    }

    public static boolean isAlnum(int c) {
        return RubyString.isUpper(c) || RubyString.isLower(c) || RubyString.isDigit(c);
    }

    public static boolean isPrint(int c) {
        return c >= 32 && c <= 126;
    }

    public IRubyObject checkStringType() {
        return this;
    }

    public IRubyObject to_s() {
        if (this.getMetaClass().getRealClass() != this.getRuntime().getString()) {
            return this.strDup(this.getRuntime().getString());
        }
        return this;
    }

    public IRubyObject op_cmp(IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newFixnum(this.cmp((RubyString)other));
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject equal(IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyString)) {
            if (!other.respondsTo("to_str")) {
                return this.getRuntime().getFalse();
            }
            Ruby runtime = this.getRuntime();
            return other.callMethod(runtime.getCurrentContext(), 9, "==", this).isTrue() ? runtime.getTrue() : runtime.getFalse();
        }
        return this.value.equal(((RubyString)other).value) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject op_plus(IRubyObject other) {
        RubyString str = RubyString.stringValue(other);
        ByteList newValue = new ByteList(this.value.length() + str.value.length());
        newValue.append(this.value);
        newValue.append(str.value);
        return RubyString.newString(this.getRuntime(), newValue).infectBy(other).infectBy(this);
    }

    public IRubyObject op_mul(IRubyObject other) {
        RubyInteger otherInteger = other.convertToInteger();
        long len = otherInteger.getLongValue();
        if (len < 0L) {
            throw this.getRuntime().newArgumentError("negative argument");
        }
        if (len > 0L && Integer.MAX_VALUE / len < (long)this.value.length()) {
            throw this.getRuntime().newArgumentError("argument too big");
        }
        ByteList newBytes = new ByteList(this.value.length() * (int)len);
        int i = 0;
        while ((long)i < len) {
            newBytes.append(this.value);
            ++i;
        }
        RubyString newString = RubyString.newString(this.getRuntime(), newBytes);
        newString.setTaint(this.isTaint());
        return newString;
    }

    public IRubyObject format(IRubyObject arg) {
        return this.getRuntime().newString((ByteList)Sprintf.sprintf(Locale.US, (CharSequence)this.value, arg));
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RubyString) {
            RubyString string = (RubyString)other;
            if (string.value.equal(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static RubyString objAsString(IRubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        IRubyObject str = obj.callMethod(obj.getRuntime().getCurrentContext(), 14, "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)obj.anyToString();
        }
        if (obj.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    public int cmp(RubyString other) {
        return this.value.cmp(other.value);
    }

    public String asSymbol() {
        return this.toString();
    }

    public RubyString newString(CharSequence s) {
        return new RubyString(this.getRuntime(), this.getType(), s);
    }

    public RubyString newString(ByteList s) {
        return new RubyString(this.getRuntime(), this.getMetaClass(), s);
    }

    public static RubyString newString(Ruby runtime, CharSequence str) {
        return new RubyString(runtime, str);
    }

    private static RubyString newEmptyString(Ruby runtime, RubyClass metaClass) {
        RubyString empty = new RubyString(runtime, metaClass, ByteList.EMPTY_BYTELIST);
        empty.shareLevel = 1;
        return empty;
    }

    public static RubyString newUnicodeString(Ruby runtime, String str) {
        try {
            return new RubyString(runtime, str.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException uee) {
            return new RubyString(runtime, str);
        }
    }

    public static RubyString newString(Ruby runtime, RubyClass clazz, CharSequence str) {
        return new RubyString(runtime, clazz, str);
    }

    public static RubyString newString(Ruby runtime, byte[] bytes) {
        return new RubyString(runtime, bytes);
    }

    public static RubyString newString(Ruby runtime, ByteList bytes) {
        return new RubyString(runtime, bytes);
    }

    public static RubyString newStringShared(Ruby runtime, RubyString orig) {
        orig.shareLevel = 1;
        RubyString str = new RubyString(runtime, orig.value);
        str.shareLevel = 1;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime, ByteList bytes) {
        return RubyString.newStringShared(runtime, runtime.getString(), bytes);
    }

    public static RubyString newStringShared(Ruby runtime, RubyClass clazz, ByteList bytes) {
        RubyString str = new RubyString(runtime, clazz, bytes);
        str.shareLevel |= 1;
        return str;
    }

    public static RubyString newString(Ruby runtime, byte[] bytes, int start, int length) {
        byte[] bytes2 = new byte[length];
        System.arraycopy(bytes, start, bytes2, 0, length);
        return new RubyString(runtime, bytes2);
    }

    public IRubyObject doClone() {
        return RubyString.newString(this.getRuntime(), this.value.dup());
    }

    public RubyString cat(byte[] str) {
        this.modify();
        this.value.append(str);
        return this;
    }

    public RubyString cat(byte[] str, int beg, int len) {
        this.modify();
        this.value.append(str, beg, len);
        return this;
    }

    public RubyString cat(ByteList str) {
        this.modify();
        this.value.append(str);
        return this;
    }

    public RubyString cat(byte ch) {
        this.modify();
        this.value.append(ch);
        return this;
    }

    public RubyString replace(IRubyObject other) {
        this.modifyCheck();
        if (this == other) {
            return this;
        }
        RubyString otherStr = RubyString.stringValue(other);
        this.shareLevel = 1;
        otherStr.shareLevel = 1;
        this.value = otherStr.value;
        this.infectBy(other);
        return this;
    }

    public RubyString reverse() {
        if (this.value.length() <= 1) {
            return this.strDup();
        }
        ByteList buf = new ByteList(this.value.length() + 2);
        buf.realSize = this.value.length();
        int src = this.value.length() - 1;
        int dst = 0;
        while (src >= 0) {
            buf.set(dst++, this.value.get(src--));
        }
        RubyString rev = new RubyString(this.getRuntime(), this.getMetaClass(), buf);
        rev.infectBy(this);
        return rev;
    }

    public RubyString reverse_bang() {
        if (this.value.length() > 1) {
            this.modify();
            for (int i = 0; i < this.value.length() / 2; ++i) {
                byte b = (byte)this.value.get(i);
                this.value.set(i, this.value.get(this.value.length() - i - 1));
                this.value.set(this.value.length() - i - 1, b);
            }
        }
        return this;
    }

    public static RubyString newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString newString = RubyString.newString(recv.getRuntime(), "");
        newString.setMetaClass((RubyClass)recv);
        newString.callInit(args, block);
        return newString;
    }

    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        if (Arity.checkArgumentCount(this.getRuntime(), args, 0, 1) == 1) {
            this.replace(args[0]);
        }
        return this;
    }

    public IRubyObject casecmp(IRubyObject other) {
        int compare = this.toString().compareToIgnoreCase(RubyString.stringValue(other).toString());
        return RubyFixnum.newFixnum(this.getRuntime(), compare == 0 ? 0L : (long)(compare < 0 ? -1 : 1));
    }

    public IRubyObject match(IRubyObject other) {
        if (other instanceof RubyRegexp) {
            return ((RubyRegexp)other).match(this);
        }
        if (other instanceof RubyString) {
            throw this.getRuntime().newTypeError("type mismatch: String given");
        }
        return other.callMethod(this.getRuntime().getCurrentContext(), "=~", this);
    }

    public IRubyObject match2() {
        return RubyRegexp.newRegexp(this, 0, null).match2();
    }

    public IRubyObject match3(IRubyObject pattern) {
        if (pattern instanceof RubyRegexp) {
            return ((RubyRegexp)pattern).search2(this.toString(), this);
        }
        if (pattern instanceof RubyString) {
            RubyRegexp regexp = RubyRegexp.newRegexp((RubyString)pattern, 0, null);
            return regexp.search2(this.toString(), this);
        }
        if (pattern.respondsTo("to_str")) {
            RubyRegexp regexp = RubyRegexp.newRegexp((RubyString)pattern.callMethod(this.getRuntime().getCurrentContext(), 17, "to_str", IRubyObject.NULL_ARRAY), 0, null);
            return regexp.search2(this.toString(), this);
        }
        throw this.getRuntime().newTypeError("wrong argument type " + pattern.getMetaClass().getBaseName() + " (expected Regexp)");
    }

    public IRubyObject capitalize() {
        RubyString str = this.strDup();
        str.capitalize_bang();
        return str;
    }

    public IRubyObject capitalize_bang() {
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        this.modify();
        int s = this.value.begin;
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        char c = (char)(buf[s] & 0xFF);
        if (Character.isLetter(c) && Character.isLowerCase(c)) {
            buf[s] = (byte)Character.toUpperCase(c);
            modify = true;
        }
        while (++s < send) {
            c = (char)(buf[s] & 0xFF);
            if (!Character.isLetter(c) || !Character.isUpperCase(c)) continue;
            buf[s] = (byte)Character.toLowerCase(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject op_ge(IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.cmp((RubyString)other) >= 0);
        }
        return RubyComparable.op_ge(this, other);
    }

    public IRubyObject op_gt(IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.cmp((RubyString)other) > 0);
        }
        return RubyComparable.op_gt(this, other);
    }

    public IRubyObject op_le(IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.cmp((RubyString)other) <= 0);
        }
        return RubyComparable.op_le(this, other);
    }

    public IRubyObject op_lt(IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.cmp((RubyString)other) < 0);
        }
        return RubyComparable.op_lt(this, other);
    }

    public IRubyObject eql_p(IRubyObject other) {
        if (!(other instanceof RubyString)) {
            return this.getRuntime().getFalse();
        }
        RubyString otherString = (RubyString)other;
        return this.value.equal(otherString.value) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyString upcase() {
        RubyString str = this.strDup();
        str.upcase_bang();
        return str;
    }

    public IRubyObject upcase_bang() {
        int s;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        this.modify();
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        for (s = this.value.begin; s < send; ++s) {
            char c = (char)(buf[s] & 0xFF);
            if (c < 'a' || c > 'z') continue;
            buf[s] = (byte)(c - 32);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    public RubyString downcase() {
        RubyString str = this.strDup();
        str.downcase_bang();
        return str;
    }

    public IRubyObject downcase_bang() {
        int s;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        this.modify();
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        for (s = this.value.begin; s < send; ++s) {
            char c = (char)(buf[s] & 0xFF);
            if (c < 'A' || c > 'Z') continue;
            buf[s] = (byte)(c + 32);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    public RubyString swapcase() {
        RubyString str = this.strDup();
        str.swapcase_bang();
        return str;
    }

    public IRubyObject swapcase_bang() {
        int s;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        this.modify();
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        for (s = this.value.begin; s < send; ++s) {
            char c = (char)(buf[s] & 0xFF);
            if (!Character.isLetter(c)) continue;
            if (Character.isUpperCase(c)) {
                buf[s] = (byte)Character.toLowerCase(c);
                modify = true;
                continue;
            }
            buf[s] = (byte)Character.toUpperCase(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject dump() {
        return this.inspect();
    }

    public IRubyObject insert(IRubyObject indexArg, IRubyObject stringArg) {
        int index = (int)indexArg.convertToInteger().getLongValue();
        if (index < 0) {
            index += this.value.length() + 1;
        }
        if (index < 0 || index > this.value.length()) {
            throw this.getRuntime().newIndexError("index " + index + " out of range");
        }
        this.modify();
        ByteList insert = stringArg.convertToString().value;
        this.value.unsafeReplace(index, 0, insert);
        return this;
    }

    public IRubyObject inspect() {
        int length = this.value.length();
        Ruby runtime = this.getRuntime();
        ByteList sb = new ByteList(length + 2 + length / 100);
        sb.append(34);
        for (int i = 0; i < length; ++i) {
            int c = this.value.get(i) & 0xFF;
            if (RubyString.isAlnum(c)) {
                sb.append((char)c);
                continue;
            }
            if (runtime.getKCode() == KCode.UTF8 && c == 239) {
                sb.append((char)c);
                sb.append((char)(this.value.get(++i) & 0xFF));
                sb.append((char)(this.value.get(++i) & 0xFF));
                continue;
            }
            if (c == 34 || c == 92) {
                sb.append(92).append((char)c);
                continue;
            }
            if (c == 35 && this.isEVStr(i, length)) {
                sb.append(92).append((char)c);
                continue;
            }
            if (RubyString.isPrint(c)) {
                sb.append((char)c);
                continue;
            }
            if (c == 10) {
                sb.append(92).append(110);
                continue;
            }
            if (c == 13) {
                sb.append(92).append(114);
                continue;
            }
            if (c == 9) {
                sb.append(92).append(116);
                continue;
            }
            if (c == 12) {
                sb.append(92).append(102);
                continue;
            }
            if (c == 11) {
                sb.append(92).append(118);
                continue;
            }
            if (c == 7) {
                sb.append(92).append(97);
                continue;
            }
            if (c == 27) {
                sb.append(92).append(101);
                continue;
            }
            sb.append(ByteList.plain(Sprintf.sprintf(runtime, (CharSequence)"\\%.3o", c)));
        }
        sb.append(34);
        return this.getRuntime().newString(sb);
    }

    private boolean isEVStr(int i, int length) {
        if (i + 1 >= length) {
            return false;
        }
        int c = this.value.get(i + 1) & 0xFF;
        return c == 36 || c == 64 || c == 123;
    }

    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.value.length());
    }

    public RubyBoolean empty() {
        return this.isEmpty() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    private boolean isEmpty() {
        return this.value.length() == 0;
    }

    public RubyString append(IRubyObject other) {
        this.infectBy(other);
        return this.cat(RubyString.stringValue((IRubyObject)other).value);
    }

    public RubyString concat(IRubyObject other) {
        long value;
        if (other instanceof RubyFixnum && (value = ((RubyFixnum)other).getLongValue()) >= 0L && value < 256L) {
            return this.cat((byte)value);
        }
        return this.append(other);
    }

    public RubyString crypt(IRubyObject other) {
        String salt = ((Object)RubyString.stringValue(other).getValue()).toString();
        if (salt.length() < 2) {
            throw this.getRuntime().newArgumentError("salt too short(need >=2 bytes)");
        }
        salt = salt.substring(0, 2);
        return this.getRuntime().newString(JavaCrypt.crypt(salt, this.toString()));
    }

    public static RubyString stringValue(IRubyObject object) {
        return (RubyString)(object instanceof RubyString ? object : object.convertToString());
    }

    public IRubyObject sub(IRubyObject[] args, Block block) {
        RubyString str = this.strDup();
        str.sub_bang(args, block);
        return str;
    }

    public IRubyObject sub_bang(IRubyObject[] args, Block block) {
        IRubyObject repl;
        boolean iter = false;
        Ruby runtime = this.getRuntime();
        boolean tainted = false;
        if (args.length == 1 && block.isGiven()) {
            iter = true;
            repl = runtime.getNil();
        } else if (args.length == 2) {
            repl = args[1].convertToString();
            tainted = repl.isTaint();
        } else {
            throw runtime.newArgumentError("wrong number of arguments (" + args.length + "for 2)");
        }
        RubyRegexp pattern = this.getPat(args[0], true);
        boolean utf8 = pattern.getCode() == KCode.UTF8;
        Pattern pat = pattern.getPattern();
        String str = this.toString(utf8);
        Matcher mat = pat.matcher(str);
        if (mat.find()) {
            ThreadContext context = runtime.getCurrentContext();
            RubyMatchData md = this.matchdata(runtime, str, mat, utf8);
            context.setBackref(md);
            if (iter) {
                int len = this.value.realSize;
                byte[] b = this.value.bytes;
                repl = RubyString.objAsString(block.yield(context, this.substr(runtime, str, mat.start(0), mat.length(0), utf8)));
                this.modifyCheck(b, len);
                this.frozenCheck();
            } else {
                repl = pattern.regsub(repl, this, md);
            }
            if (repl.isTaint()) {
                tainted = true;
            }
            int startZ = mat.start(0);
            if (utf8) {
                try {
                    startZ = str.substring(0, startZ).getBytes("UTF8").length;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            int plen = mat.end(0) - startZ;
            if (utf8) {
                try {
                    plen = mat.group(0).getBytes("UTF8").length;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            ByteList replValue = ((RubyString)repl).value;
            if (replValue.realSize > plen) {
                this.modify(this.value.realSize + replValue.realSize - plen);
            } else {
                this.modify();
            }
            if (replValue.realSize != plen && this.value.realSize - startZ - plen > 0) {
                int valueOldStart = this.value.begin + startZ + plen;
                int valueNewStart = this.value.begin + startZ + replValue.realSize;
                int valueLength = this.value.realSize - startZ - plen;
                System.arraycopy(this.value.bytes, valueOldStart, this.value.bytes, valueNewStart, valueLength);
            }
            System.arraycopy(replValue.bytes, replValue.begin, this.value.bytes, this.value.begin + startZ, replValue.realSize);
            this.value.realSize += replValue.realSize - plen;
            if (tainted) {
                this.setTaint(true);
            }
            return this;
        }
        return runtime.getNil();
    }

    public IRubyObject gsub(IRubyObject[] args, Block block) {
        return this.gsub(args, block, false);
    }

    public IRubyObject gsub_bang(IRubyObject[] args, Block block) {
        return this.gsub(args, block, true);
    }

    /*
     * WARNING - void declaration
     */
    private final IRubyObject gsub(IRubyObject[] args, Block block, boolean bang) {
        IRubyObject repl;
        boolean iter = false;
        Ruby runtime = this.getRuntime();
        boolean tainted = false;
        if (args.length == 1 && block.isGiven()) {
            iter = true;
            repl = runtime.getNil();
        } else if (args.length == 2) {
            repl = args[1].convertToString();
            tainted = repl.isTaint();
        } else {
            throw runtime.newArgumentError("wrong number of arguments (" + args.length + "for 2)");
        }
        RubyRegexp pattern = this.getPat(args[0], true);
        boolean utf8 = pattern.getCode() == KCode.UTF8;
        Pattern pat = pattern.getPattern();
        String str = this.toString(utf8);
        Matcher mat = pat.matcher(str);
        boolean found = mat.find();
        if (!found) {
            if (bang) {
                return runtime.getNil();
            }
            return this.strDup();
        }
        int blen = this.value.realSize + 30;
        ByteList dest = new ByteList(blen);
        dest.realSize = blen;
        int buf = 0;
        int bp = 0;
        int cp = this.value.begin;
        byte[] sb = this.value.bytes;
        int slen = this.value.realSize;
        ThreadContext context = runtime.getCurrentContext();
        int offset = 0;
        RubyMatchData md = null;
        while (found) {
            int endZ;
            RubyString val;
            if (iter) {
                context.setBackref(this.matchdata(runtime, str, mat, utf8));
                val = RubyString.objAsString(block.yield(context, this.substr(runtime, str, mat.start(0), mat.length(0), utf8)));
                this.modifyCheck(sb, slen);
                if (bang) {
                    this.frozenCheck();
                }
            } else {
                void var5_7;
                if (md == null) {
                    md = this.matchdata(runtime, str, mat, utf8);
                    context.setBackref(md);
                } else {
                    md.invalidateRegs();
                }
                val = pattern.regsub((IRubyObject)var5_7, this, md);
            }
            if (val.isTaint()) {
                tainted = true;
            }
            ByteList vbuf = val.value;
            int beg = mat.start();
            int len = bp - buf + (beg - offset) + vbuf.realSize + 3;
            if (blen < len) {
                while (blen < len) {
                    blen <<= 1;
                }
                len = bp - buf;
                dest.realloc(blen);
                dest.realSize = blen;
                bp = buf + len;
            }
            len = beg - offset;
            System.arraycopy(this.value.bytes, cp, dest.bytes, bp, len);
            System.arraycopy(vbuf.bytes, vbuf.begin, dest.bytes, bp += len, vbuf.realSize);
            bp += vbuf.realSize;
            offset = endZ = mat.end(0);
            if (mat.length(0) == 0) {
                if (this.value.realSize <= endZ) break;
                len = 1;
                System.arraycopy(this.value.bytes, this.value.begin + endZ, dest.bytes, bp, len);
                bp += len;
                offset = endZ + len;
            }
            cp = this.value.begin + offset;
            if (offset > this.value.realSize) break;
            mat.setPosition(offset);
            found = mat.find();
        }
        if (this.value.realSize > offset) {
            int len = bp - buf;
            if (blen - len < this.value.realSize - offset) {
                blen = len + this.value.realSize - offset;
                dest.realloc(blen);
                bp = buf + len;
            }
            System.arraycopy(this.value.bytes, cp, dest.bytes, bp, this.value.realSize - offset);
            bp += this.value.realSize - offset;
        }
        dest.realSize = bp - buf;
        if (bang) {
            this.view(dest);
            if (tainted) {
                this.setTaint(true);
            }
            return this;
        }
        RubyString destStr = new RubyString(runtime, this.getMetaClass(), dest);
        destStr.infectBy(this);
        if (tainted) {
            destStr.setTaint(true);
        }
        return destStr;
    }

    public IRubyObject index(IRubyObject[] args) {
        return this.index(args, false);
    }

    public IRubyObject rindex(IRubyObject[] args) {
        return this.index(args, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IRubyObject index(IRubyObject[] args, boolean reverse) {
        int pos;
        boolean offset = false;
        if (Arity.checkArgumentCount(this.getRuntime(), args, 1, 2) == 2) {
            pos = RubyNumeric.fix2int(args[1]);
            if (pos > this.value.length()) {
                if (!reverse) return this.getRuntime().getNil();
                pos = this.value.length();
            } else if (pos < 0 && (pos += this.value.length()) < 0) {
                return this.getRuntime().getNil();
            }
            offset = true;
        } else {
            int n = pos = !reverse ? 0 : this.value.length();
        }
        if (args[0] instanceof RubyRegexp) {
            int doNotLookPastIfReverse = pos;
            pos = ((RubyRegexp)args[0]).search(this.toString(), this, reverse ? 0 : pos);
            if (!reverse) return pos == -1 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(pos);
            if (pos == -1) {
                return this.getRuntime().getNil();
            }
            int dummy = pos;
            if (offset && dummy > (pos = doNotLookPastIfReverse)) {
                pos = -1;
                dummy = -1;
            }
            while (reverse && dummy > -1 && dummy <= doNotLookPastIfReverse) {
                pos = dummy;
                dummy = ((RubyRegexp)args[0]).search(this.toString(), this, pos + 1);
            }
            return pos == -1 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(pos);
        } else if (args[0] instanceof RubyFixnum) {
            char c = (char)((RubyFixnum)args[0]).getLongValue();
            pos = reverse ? this.value.lastIndexOf(c, pos) : this.value.indexOf(c, pos);
            return pos == -1 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(pos);
        } else {
            IRubyObject tmp = args[0].checkStringType();
            if (tmp.isNil()) {
                throw this.getRuntime().newTypeError("type mismatch: " + args[0].getMetaClass().getName() + " given");
            }
            ByteList sub = ((RubyString)tmp).value;
            if (sub.length() > this.value.length()) {
                return this.getRuntime().getNil();
            }
            if (sub.realSize == 0) {
                return this.getRuntime().newFixnum(pos);
            }
            pos = reverse ? this.value.lastIndexOf(sub, pos) : this.value.indexOf(sub, pos);
        }
        return pos == -1 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(pos);
    }

    public IRubyObject substr(int beg, int len) {
        int length = this.value.length();
        if (len < 0 || beg > length) {
            return this.getRuntime().getNil();
        }
        if (beg < 0 && (beg += length) < 0) {
            return this.getRuntime().getNil();
        }
        int end = Math.min(length, beg + len);
        return this.makeShared(beg, end - beg);
    }

    public IRubyObject replace(int beg, int len, RubyString replaceWith) {
        if (beg + len >= this.value.length()) {
            len = this.value.length() - beg;
        }
        this.modify();
        this.value.unsafeReplace(beg, len, replaceWith.value);
        return this.infectBy(replaceWith);
    }

    public IRubyObject aref(IRubyObject[] args) {
        if (Arity.checkArgumentCount(this.getRuntime(), args, 1, 2) == 2) {
            if (args[0] instanceof RubyRegexp) {
                IRubyObject match = RubyRegexp.regexpValue(args[0]).match(this.toString(), this, 0);
                long idx = args[1].convertToInteger().getLongValue();
                this.getRuntime().getCurrentContext().setBackref(match);
                return RubyRegexp.nth_match((int)idx, match);
            }
            return this.substr(RubyNumeric.fix2int(args[0]), RubyNumeric.fix2int(args[1]));
        }
        if (args[0] instanceof RubyRegexp) {
            return RubyRegexp.regexpValue(args[0]).search(this.toString(), this, 0) >= 0 ? RubyRegexp.last_match(this.getRuntime().getCurrentContext().getBackref()) : this.getRuntime().getNil();
        }
        if (args[0] instanceof RubyString) {
            return this.toString().indexOf(RubyString.stringValue(args[0]).toString()) != -1 ? args[0] : this.getRuntime().getNil();
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.value.length(), true, false);
            return begLen == null ? this.getRuntime().getNil() : this.substr((int)begLen[0], (int)begLen[1]);
        }
        int idx = (int)args[0].convertToInteger().getLongValue();
        if (idx < 0) {
            idx += this.value.length();
        }
        if (idx < 0 || idx >= this.value.length()) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.value.get(idx) & 0xFF);
    }

    private void subpatSet(RubyRegexp regexp, int nth, IRubyObject repl) {
        int found = regexp.search(this.toString(), this, 0);
        if (found == -1) {
            throw this.getRuntime().newIndexError("regexp not matched");
        }
        RubyMatchData match = (RubyMatchData)this.getRuntime().getCurrentContext().getBackref();
        if ((long)nth >= match.getSize()) {
            throw this.getRuntime().newIndexError("index " + nth + " out of regexp");
        }
        if (nth < 0) {
            if ((long)(-nth) >= match.getSize()) {
                throw this.getRuntime().newIndexError("index " + nth + " out of regexp");
            }
            nth = (int)((long)nth + match.getSize());
        }
        IRubyObject group = match.group(nth);
        if (this.getRuntime().getNil().equals(group)) {
            throw this.getRuntime().newIndexError("regexp group " + nth + " not matched");
        }
        int beg = match.begin(nth);
        int len = match.end(nth) - beg;
        this.replace(beg, len, RubyString.stringValue(repl));
    }

    public IRubyObject aset(IRubyObject[] args) {
        int strLen = this.value.length();
        if (Arity.checkArgumentCount(this.getRuntime(), args, 2, 3) == 3) {
            if (args[0] instanceof RubyFixnum) {
                RubyString repl = RubyString.stringValue(args[2]);
                int beg = RubyNumeric.fix2int(args[0]);
                int len = RubyNumeric.fix2int(args[1]);
                if (len < 0) {
                    throw this.getRuntime().newIndexError("negative length");
                }
                if (beg < 0) {
                    beg += strLen;
                }
                if (beg < 0 || beg > 0 && beg > strLen) {
                    throw this.getRuntime().newIndexError("string index out of bounds");
                }
                if (beg + len > strLen) {
                    len = strLen - beg;
                }
                this.replace(beg, len, repl);
                return repl;
            }
            if (args[0] instanceof RubyRegexp) {
                RubyString repl = RubyString.stringValue(args[2]);
                int nth = RubyNumeric.fix2int(args[1]);
                this.subpatSet((RubyRegexp)args[0], nth, repl);
                return repl;
            }
        }
        if (args[0] instanceof RubyFixnum || args[0].respondsTo("to_int")) {
            int idx = 0;
            idx = !(args[0] instanceof RubyFixnum) ? (int)args[0].convertToInteger().getLongValue() : RubyNumeric.fix2int(args[0]);
            if (idx < 0) {
                idx += this.value.length();
            }
            if (idx < 0 || idx >= this.value.length()) {
                throw this.getRuntime().newIndexError("string index out of bounds");
            }
            if (args[1] instanceof RubyFixnum) {
                this.modify();
                this.value.set(idx, (byte)RubyNumeric.fix2int(args[1]));
            } else {
                this.replace(idx, 1, RubyString.stringValue(args[1]));
            }
            return args[1];
        }
        if (args[0] instanceof RubyRegexp) {
            RubyString repl = RubyString.stringValue(args[1]);
            this.subpatSet((RubyRegexp)args[0], 0, repl);
            return repl;
        }
        if (args[0] instanceof RubyString) {
            RubyString orig = RubyString.stringValue(args[0]);
            int beg = this.toString().indexOf(orig.toString());
            if (beg != -1) {
                this.replace(beg, orig.value.length(), RubyString.stringValue(args[1]));
            }
            return args[1];
        }
        if (args[0] instanceof RubyRange) {
            long[] idxs = ((RubyRange)args[0]).getBeginLength(this.value.length(), true, true);
            this.replace((int)idxs[0], (int)idxs[1], RubyString.stringValue(args[1]));
            return args[1];
        }
        throw this.getRuntime().newTypeError("wrong argument type");
    }

    public IRubyObject slice_bang(IRubyObject[] args) {
        int argc = Arity.checkArgumentCount(this.getRuntime(), args, 1, 2);
        IRubyObject[] newArgs = new IRubyObject[argc + 1];
        newArgs[0] = args[0];
        if (argc > 1) {
            newArgs[1] = args[1];
        }
        newArgs[argc] = this.newString("");
        IRubyObject result = this.aref(args);
        if (result.isNil()) {
            return result;
        }
        this.aset(newArgs);
        return result;
    }

    public IRubyObject succ() {
        return this.strDup().succ_bang();
    }

    public IRubyObject succ_bang() {
        int i;
        if (this.value.length() == 0) {
            return this;
        }
        this.modify();
        boolean alnumSeen = false;
        int pos = -1;
        int c = 0;
        int n = 0;
        for (i = this.value.length() - 1; i >= 0; --i) {
            c = this.value.get(i) & 0xFF;
            if (!RubyString.isAlnum(c)) continue;
            alnumSeen = true;
            if (RubyString.isDigit(c) && c < 57 || RubyString.isLower(c) && c < 122 || RubyString.isUpper(c) && c < 90) {
                this.value.set(i, (byte)(c + 1));
                pos = -1;
                break;
            }
            pos = i;
            int n2 = RubyString.isDigit(c) ? 49 : (n = RubyString.isLower(c) ? 97 : 65);
            this.value.set(i, (byte)(RubyString.isDigit(c) ? 48 : (RubyString.isLower(c) ? 97 : 65)));
        }
        if (!alnumSeen) {
            for (i = this.value.length() - 1; i >= 0; --i) {
                c = this.value.get(i) & 0xFF;
                if (c < 255) {
                    this.value.set(i, (byte)(c + 1));
                    pos = -1;
                    break;
                }
                pos = i;
                n = 1;
                this.value.set(i, 0);
            }
        }
        if (pos > -1) {
            this.value.prepend((byte)n);
        }
        return this;
    }

    public IRubyObject upto(IRubyObject str, Block block) {
        return this.upto(str, false, block);
    }

    public IRubyObject upto(IRubyObject str, boolean excl, Block block) {
        RubyString beg = this;
        RubyString end = RubyString.stringValue(str);
        int n = beg.cmp(end);
        if (n > 0 || excl && n == 0) {
            return beg;
        }
        RubyString afterEnd = RubyString.stringValue(end.succ());
        RubyString current = beg;
        ThreadContext context = this.getRuntime().getCurrentContext();
        while (!current.equals(afterEnd)) {
            block.yield(context, current);
            if (!excl && current.equals(end)) break;
            current = (RubyString)current.succ();
            if ((!excl || !current.equals(end)) && current.length().getLongValue() <= end.length().getLongValue()) continue;
            break;
        }
        return beg;
    }

    public RubyBoolean include(IRubyObject obj) {
        if (obj instanceof RubyFixnum) {
            int c = RubyNumeric.fix2int(obj);
            for (int i = 0; i < this.value.length(); ++i) {
                if (this.value.get(i) != (byte)c) continue;
                return this.getRuntime().getTrue();
            }
            return this.getRuntime().getFalse();
        }
        ByteList str = RubyString.stringValue((IRubyObject)obj).value;
        return this.getRuntime().newBoolean(this.value.indexOf(str) != -1);
    }

    public IRubyObject to_i(IRubyObject[] args) {
        long base = Arity.checkArgumentCount(this.getRuntime(), args, 0, 1) == 0 ? 10L : args[0].convertToInteger().getLongValue();
        return RubyNumeric.str2inum(this.getRuntime(), this, (int)base);
    }

    public IRubyObject oct() {
        int pos;
        if (this.isEmpty()) {
            return this.getRuntime().newFixnum(0L);
        }
        int base = 8;
        String str = this.toString().trim();
        int n = pos = str.charAt(0) == '-' || str.charAt(0) == '+' ? 1 : 0;
        if (str.indexOf("0x") == pos || str.indexOf("0X") == pos) {
            base = 16;
        } else if (str.indexOf("0b") == pos || str.indexOf("0B") == pos) {
            base = 2;
        }
        return RubyNumeric.str2inum(this.getRuntime(), this, base);
    }

    public IRubyObject hex() {
        return RubyNumeric.str2inum(this.getRuntime(), this, 16);
    }

    public IRubyObject to_f() {
        return RubyNumeric.str2fnum(this.getRuntime(), this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RubyArray split(IRubyObject[] args) {
        RubyArray result;
        boolean limit;
        int lim;
        block35: {
            String str;
            int end;
            int beg;
            IRubyObject spat;
            Ruby runtime;
            int i;
            block37: {
                int ptr;
                i = 0;
                lim = 0;
                limit = false;
                runtime = this.getRuntime();
                if (Arity.checkArgumentCount(runtime, args, 0, 2) == 2) {
                    lim = RubyNumeric.fix2int(args[1]);
                    if (lim == 1) {
                        if (this.value.realSize == 0) {
                            return runtime.newArray();
                        }
                        return runtime.newArray(this);
                    }
                    if (lim > 0) {
                        limit = true;
                    }
                    if (lim > 0) {
                        limit = true;
                    }
                    i = 1;
                }
                spat = args.length == 0 || args[0].isNil() ? null : args[0];
                boolean awkSplit = false;
                if (spat == null && (spat = runtime.getGlobalVariables().get("$;")).isNil()) {
                    awkSplit = true;
                } else if (spat instanceof RubyString && ((RubyString)spat).value.realSize == 1) {
                    if (((RubyString)spat).value.get(0) == 32) {
                        awkSplit = true;
                    } else {
                        String stringPattern = RubyString.stringValue(spat).toString();
                        spat = RubyRegexp.newRegexp(runtime, RubyRegexp.escapeSpecialChars(stringPattern), 0, null);
                    }
                } else {
                    spat = this.getPat(spat, true);
                }
                result = runtime.newArray();
                if (!awkSplit) break block37;
                int eptr = ptr + this.value.realSize;
                byte[] buff = this.value.bytes;
                boolean skip = true;
                beg = 0;
                end = 0;
                for (ptr = this.value.begin; ptr < eptr; ++ptr) {
                    if (skip) {
                        if (Character.isWhitespace((char)(buff[ptr] & 0xFF))) {
                            ++beg;
                            continue;
                        }
                        end = beg + 1;
                        skip = false;
                        if (!limit || lim > i) continue;
                        break;
                    }
                    if (Character.isWhitespace((char)(buff[ptr] & 0xFF))) {
                        result.append(this.makeShared(beg, end - beg));
                        skip = true;
                        beg = end + 1;
                        if (!limit) continue;
                        ++i;
                        continue;
                    }
                    ++end;
                }
                if (this.value.realSize > 0 && (limit || this.value.realSize > beg || lim < 0)) {
                    if (this.value.length() == beg) {
                        result.append(RubyString.newEmptyString(runtime, this.getMetaClass()));
                        break block35;
                    } else {
                        result.append(this.makeShared(beg, this.value.realSize - beg));
                    }
                }
                break block35;
            }
            boolean utf8 = false;
            RubyRegexp rr = (RubyRegexp)spat;
            if (runtime.getKCode() == KCode.UTF8) {
                CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPORT);
                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                try {
                    str = decoder.decode(ByteBuffer.wrap(this.value.unsafeBytes(), this.value.begin, this.value.realSize)).toString();
                    utf8 = true;
                }
                catch (CharacterCodingException cce) {
                    str = this.toString();
                }
            } else {
                utf8 = rr.getCode() == KCode.UTF8;
                str = this.toString(utf8);
            }
            Pattern pat = rr.getPattern();
            Matcher mat = pat.matcher(str);
            beg = 0;
            boolean lastNull = false;
            while (mat.find()) {
                block36: {
                    end = mat.start();
                    if (beg == end && mat.length(0) == 0) {
                        if (this.value.realSize == 0) {
                            result.append(RubyString.newEmptyString(runtime, this.getMetaClass()));
                            break;
                        }
                        if (lastNull) {
                            beg = end;
                            break block36;
                        } else {
                            lastNull = true;
                            continue;
                        }
                    }
                    result.append(this.substr(runtime, str, beg, end - beg, utf8));
                    beg = mat.end(0);
                }
                lastNull = false;
                for (int index = 1; index < mat.groupCount(); ++index) {
                    if (!mat.isCaptured(index)) continue;
                    int iLength = mat.length(index);
                    if (iLength == 0) {
                        result.append(RubyString.newEmptyString(runtime, this.getMetaClass()));
                        continue;
                    }
                    result.append(this.substr(runtime, str, mat.start(index), iLength, utf8));
                }
                if (!limit || lim > ++i) continue;
            }
            if (str.length() > 0 && (limit || str.length() > beg || lim < 0)) {
                if (str.length() == beg) {
                    result.append(RubyString.newEmptyString(runtime, this.getMetaClass()));
                } else {
                    result.append(this.substr(runtime, str, beg, str.length() - beg, utf8));
                }
            }
        }
        if (!limit && lim == 0) {
            while (result.size() > 0 && ((RubyString)result.eltInternal((int)(result.size() - 1))).value.realSize == 0) {
                result.pop();
            }
        }
        return result;
    }

    private final RubyRegexp getPat(IRubyObject pattern, boolean quote) {
        if (pattern instanceof RubyRegexp) {
            return (RubyRegexp)pattern;
        }
        if (!(pattern instanceof RubyString)) {
            IRubyObject val = pattern.checkStringType();
            if (val.isNil()) {
                throw this.getRuntime().newTypeError("wrong argument type " + pattern.getMetaClass() + " (expected Regexp)");
            }
            pattern = val;
        }
        RubyString strPattern = (RubyString)pattern;
        String str = strPattern.toString();
        if (quote) {
            str = RubyRegexp.escapeSpecialChars(strPattern.toString());
        }
        return RubyRegexp.newRegexp(this.getRuntime(), str, 0, null);
    }

    public IRubyObject scan(IRubyObject arg, Block block) {
        RubyRegexp pattern = this.getPat(arg, true);
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        boolean utf8 = pattern.getCode() == KCode.UTF8;
        String str = this.toString(utf8);
        Pattern pat = pattern.getPattern();
        Matcher mat = pat.matcher(str);
        if (!block.isGiven()) {
            RubyArray result = runtime.newArray();
            RubyMatchData md = this.matchdata(runtime, str, mat, utf8);
            context.setBackref(md);
            while (mat.find()) {
                int groups = mat.groupCount();
                if (groups == 1) {
                    result.append(this.substr(runtime, str, mat.start(0), mat.length(0), utf8));
                } else {
                    RubyArray sub = runtime.newArray(groups);
                    for (int i = 1; i < groups; ++i) {
                        sub.append(mat.isCaptured(i) ? this.substr(runtime, str, mat.start(i), mat.length(i), utf8) : runtime.getNil());
                    }
                    result.append(sub);
                }
                md.invalidateRegs();
            }
            return result;
        }
        while (mat.find()) {
            int groups = mat.groupCount();
            context.setBackref(this.matchdata(runtime, str, mat, utf8));
            if (groups == 1) {
                block.yield(context, this.substr(runtime, str, mat.start(0), mat.length(0), utf8));
                continue;
            }
            RubyArray sub = runtime.newArray(groups);
            for (int i = 1; i < groups; ++i) {
                sub.append(mat.isCaptured(i) ? this.substr(runtime, str, mat.start(i), mat.length(i), utf8) : runtime.getNil());
            }
            block.yield(context, sub);
        }
        return this;
    }

    private final RubyString substr(Ruby runtime, String str, int beg, int len, boolean utf8) {
        if (utf8) {
            if (len == 0) {
                return RubyString.newEmptyString(runtime, this.getMetaClass());
            }
            return new RubyString(runtime, this.getMetaClass(), RubyString.toUTF(str.substring(beg, beg + len)));
        }
        return this.makeShared(beg, len);
    }

    private final String toString(boolean utf8) {
        String str = this.toString();
        if (utf8) {
            try {
                str = new String(ByteList.plain(str), "UTF8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return str;
    }

    private final RubyMatchData matchdata(Ruby runtime, String str, Matcher mat, boolean utf8) {
        if (utf8) {
            return new RubyMatchData.JavaString(runtime, str, mat);
        }
        return new RubyMatchData.RString(runtime, this, mat);
    }

    private final IRubyObject justify(IRubyObject[] args, char jflag) {
        int pend;
        byte[] fbuf;
        int f;
        IRubyObject pad;
        Ruby runtime = this.getRuntime();
        Arity.scanArgs(runtime, args, 1, 1);
        int width = RubyFixnum.num2int(args[0]);
        int flen = 0;
        if (args.length == 2) {
            pad = args[1].convertToString();
            ByteList fList = pad.value;
            f = fList.begin;
            flen = fList.realSize;
            if (flen == 0) {
                throw this.getRuntime().newArgumentError("zero width padding");
            }
            fbuf = fList.bytes;
        } else {
            f = RubyString.SPACE_BYTELIST.begin;
            flen = RubyString.SPACE_BYTELIST.realSize;
            fbuf = RubyString.SPACE_BYTELIST.bytes;
            pad = runtime.getNil();
        }
        if (width < 0 || this.value.realSize >= width) {
            return this.strDup();
        }
        ByteList res = new ByteList(width);
        res.realSize = width;
        int p = res.begin;
        byte[] pbuf = res.bytes;
        if (jflag != 'l') {
            int n = width - this.value.realSize;
            pend = p + (jflag == 'r' ? n : n / 2);
            if (flen <= 1) {
                while (p < pend) {
                    pbuf[p++] = fbuf[f];
                }
            } else {
                int q = f;
                while (p + flen <= pend) {
                    System.arraycopy(fbuf, f, pbuf, p, flen);
                    p += flen;
                }
                while (p < pend) {
                    pbuf[p++] = fbuf[q++];
                }
            }
        }
        System.arraycopy(this.value.bytes, this.value.begin, pbuf, p, this.value.realSize);
        if (jflag != 'r') {
            p += this.value.realSize;
            pend = res.begin + width;
            if (flen <= 1) {
                while (p < pend) {
                    pbuf[p++] = fbuf[f];
                }
            } else {
                while (p + flen <= pend) {
                    System.arraycopy(fbuf, f, pbuf, p, flen);
                    p += flen;
                }
                while (p < pend) {
                    pbuf[p++] = fbuf[f++];
                }
            }
        }
        RubyString resStr = new RubyString(runtime, this.getMetaClass(), res);
        resStr.infectBy(this);
        if (flen > 0) {
            resStr.infectBy(pad);
        }
        return resStr;
    }

    public IRubyObject ljust(IRubyObject[] args) {
        return this.justify(args, 'l');
    }

    public IRubyObject rjust(IRubyObject[] args) {
        return this.justify(args, 'r');
    }

    public IRubyObject center(IRubyObject[] args) {
        return this.justify(args, 'c');
    }

    public IRubyObject chop() {
        RubyString str = this.strDup();
        str.chop_bang();
        return str;
    }

    public IRubyObject chop_bang() {
        int end = this.value.realSize - 1;
        if (end < 0) {
            return this.getRuntime().getNil();
        }
        if (this.value.bytes[this.value.begin + end] == 10 && end > 0 && this.value.bytes[this.value.begin + end - 1] == 13) {
            --end;
        }
        this.view(0, end);
        return this;
    }

    public RubyString chomp(IRubyObject[] args) {
        RubyString str = this.strDup();
        str.chomp_bang(args);
        return str;
    }

    public IRubyObject chomp_bang(IRubyObject[] args) {
        String separator;
        if (this.isEmpty()) {
            return this.getRuntime().getNil();
        }
        String string = separator = args.length == 0 ? this.getRuntime().getGlobalVariables().get("$/").asSymbol() : args[0].asSymbol();
        if (separator.equals(DEFAULT_RS)) {
            int end = this.value.realSize - 1;
            int removeCount = 0;
            if (end < 0) {
                return this.getRuntime().getNil();
            }
            if ((this.value.get(end) & 0xFF) == 10) {
                ++removeCount;
                if (end > 0 && (this.value.get(end - 1) & 0xFF) == 13) {
                    ++removeCount;
                }
            } else if ((this.value.get(end) & 0xFF) == 13) {
                ++removeCount;
            }
            if (removeCount == 0) {
                return this.getRuntime().getNil();
            }
            this.view(0, end - removeCount + 1);
            return this;
        }
        if (separator.length() == 0) {
            int end = this.value.realSize - 1;
            int removeCount = 0;
            while (end - removeCount >= 0 && (this.value.get(end - removeCount) & 0xFF) == 10) {
                if (end - ++removeCount < 0 || (this.value.get(end - removeCount) & 0xFF) != 13) continue;
                ++removeCount;
            }
            if (removeCount == 0) {
                return this.getRuntime().getNil();
            }
            this.view(0, end - removeCount + 1);
            return this;
        }
        if (this.toString().endsWith(separator)) {
            this.view(0, this.value.realSize - separator.length());
            return this;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject lstrip() {
        RubyString str = this.strDup();
        str.lstrip_bang();
        return str;
    }

    public IRubyObject lstrip_bang() {
        int i;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        for (i = 0; i < this.value.realSize && WHITESPACE[this.value.bytes[this.value.begin + i] + 128]; ++i) {
        }
        if (i > 0) {
            this.view(i, this.value.realSize - i);
            return this;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject rstrip() {
        RubyString str = this.strDup();
        str.rstrip_bang();
        return str;
    }

    public IRubyObject rstrip_bang() {
        int i;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        for (i = this.value.realSize - 1; i >= 0 && this.value.bytes[this.value.begin + i] == 0; --i) {
        }
        while (i >= 0 && WHITESPACE[this.value.bytes[this.value.begin + i] + 128]) {
            --i;
        }
        if (i < this.value.realSize - 1) {
            this.view(0, i + 1);
            return this;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject strip() {
        RubyString str = this.strDup();
        str.strip_bang();
        return str;
    }

    public IRubyObject strip_bang() {
        IRubyObject l = this.lstrip_bang();
        IRubyObject r = this.rstrip_bang();
        if (l.isNil() && r.isNil()) {
            return l;
        }
        return this;
    }

    public IRubyObject count(IRubyObject[] args) {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        if (this.value.realSize == 0) {
            return this.getRuntime().newFixnum(0L);
        }
        boolean[] table = new boolean[256];
        boolean init = true;
        for (int i = 0; i < args.length; ++i) {
            RubyString s = args[i].convertToString();
            s.setup_table(table, init);
            init = false;
        }
        int s = this.value.begin;
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        int i = 0;
        while (s < send) {
            if (!table[buf[s++] & 0xFF]) continue;
            ++i;
        }
        return this.getRuntime().newFixnum(i);
    }

    public IRubyObject delete(IRubyObject[] args) {
        RubyString str = this.strDup();
        str.delete_bang(args);
        return str;
    }

    public IRubyObject delete_bang(IRubyObject[] args) {
        int s;
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        boolean[] squeeze = new boolean[256];
        boolean init = true;
        for (int i = 0; i < args.length; ++i) {
            RubyString s2 = args[i].convertToString();
            s2.setup_table(squeeze, init);
            init = false;
        }
        this.modify();
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        int t = s = this.value.begin;
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        while (s < send) {
            if (squeeze[buf[s] & 0xFF]) {
                modify = true;
            } else {
                buf[t++] = buf[s];
            }
            ++s;
        }
        this.value.realSize = t - this.value.begin;
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject squeeze(IRubyObject[] args) {
        RubyString str = this.strDup();
        str.squeeze_bang(args);
        return str;
    }

    public IRubyObject squeeze_bang(IRubyObject[] args) {
        int s;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        boolean[] squeeze = new boolean[256];
        if (args.length == 0) {
            for (int i = 0; i < 256; ++i) {
                squeeze[i] = true;
            }
        } else {
            boolean init = true;
            for (int i = 0; i < args.length; ++i) {
                RubyString s2 = args[i].convertToString();
                s2.setup_table(squeeze, init);
                init = false;
            }
        }
        this.modify();
        int t = s = this.value.begin;
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        int save = -1;
        while (s < send) {
            int c;
            if ((c = buf[s++] & 0xFF) == save && squeeze[c]) continue;
            int n = t++;
            save = c;
            buf[n] = (byte)save;
        }
        if (t - this.value.begin != this.value.realSize) {
            this.value.realSize = t - this.value.begin;
            return this;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject tr(IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup();
        str.tr_trans(src, repl, false);
        return str;
    }

    public IRubyObject tr_bang(IRubyObject src, IRubyObject repl) {
        return this.tr_trans(src, repl, false);
    }

    private final void setup_table(boolean[] table, boolean init) {
        int c;
        int i;
        boolean[] buf = new boolean[256];
        TR tr = new TR();
        boolean cflag = false;
        tr.p = this.value.begin;
        tr.pend = this.value.begin + this.value.realSize;
        tr.buf = this.value.bytes;
        tr.max = 0;
        tr.now = 0;
        tr.gen = 0;
        if (this.value.realSize > 1 && this.value.bytes[this.value.begin] == 94) {
            cflag = true;
            ++tr.p;
        }
        if (init) {
            for (i = 0; i < 256; ++i) {
                table[i] = true;
            }
        }
        for (i = 0; i < 256; ++i) {
            buf[i] = cflag;
        }
        while ((c = this.trnext(tr)) >= 0) {
            buf[c & 0xFF] = !cflag;
        }
        for (i = 0; i < 256; ++i) {
            table[i] = table[i] && buf[i];
        }
    }

    private final IRubyObject tr_trans(IRubyObject src, IRubyObject repl, boolean sflag) {
        int s;
        int c;
        int i;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        ByteList replList = repl.convertToString().value;
        if (replList.realSize == 0) {
            return this.delete_bang(new IRubyObject[]{src});
        }
        ByteList srcList = src.convertToString().value;
        TR trsrc = new TR();
        TR trrepl = new TR();
        boolean cflag = false;
        boolean modify = false;
        trsrc.p = srcList.begin;
        trsrc.pend = srcList.begin + srcList.realSize;
        trsrc.buf = srcList.bytes;
        if (srcList.realSize >= 2 && srcList.bytes[srcList.begin] == 94) {
            cflag = true;
            ++trsrc.p;
        }
        trrepl.p = replList.begin;
        trrepl.pend = replList.begin + replList.realSize;
        trrepl.buf = replList.bytes;
        trrepl.gen = 0;
        trsrc.gen = 0;
        trrepl.now = 0;
        trsrc.now = 0;
        trrepl.max = 0;
        trsrc.max = 0;
        int[] trans = new int[256];
        if (cflag) {
            for (i = 0; i < 256; ++i) {
                trans[i] = 1;
            }
            while ((c = this.trnext(trsrc)) >= 0) {
                trans[c & 0xFF] = -1;
            }
            while ((c = this.trnext(trrepl)) >= 0) {
            }
            for (i = 0; i < 256; ++i) {
                if (trans[i] < 0) continue;
                trans[i] = trrepl.now;
            }
        } else {
            for (i = 0; i < 256; ++i) {
                trans[i] = -1;
            }
            while ((c = this.trnext(trsrc)) >= 0) {
                int r = this.trnext(trrepl);
                if (r == -1) {
                    r = trrepl.now;
                }
                trans[c & 0xFF] = r;
            }
        }
        this.modify();
        int send = s + this.value.realSize;
        byte[] sbuf = this.value.bytes;
        if (sflag) {
            int t = s;
            int last = -1;
            while (s < send) {
                byte c0;
                if ((c = trans[(c0 = sbuf[s++]) & 0xFF]) >= 0) {
                    if (last == c) continue;
                    last = c;
                    sbuf[t++] = (byte)(c & 0xFF);
                    modify = true;
                    continue;
                }
                last = -1;
                sbuf[t++] = c0;
            }
            if (this.value.realSize > t - this.value.begin) {
                this.value.realSize = t - this.value.begin;
                modify = true;
            }
        } else {
            for (s = this.value.begin; s < send; ++s) {
                c = trans[sbuf[s] & 0xFF];
                if (c < 0) continue;
                sbuf[s] = (byte)(c & 0xFF);
                modify = true;
            }
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    private final int trnext(TR t) {
        byte[] buf = t.buf;
        while (t.gen == 0) {
            if (t.p == t.pend) {
                return -1;
            }
            if (t.p < t.pend - 1 && buf[t.p] == 92) {
                ++t.p;
            }
            t.now = buf[t.p++];
            if (t.p < t.pend - 1 && buf[t.p] == 45) {
                ++t.p;
                if (t.p < t.pend) {
                    if (t.now > buf[t.p]) {
                        ++t.p;
                        continue;
                    }
                    t.gen = 1;
                    t.max = buf[t.p++];
                }
            }
            return t.now & 0xFF;
        }
        if (++t.now < t.max) {
            return t.now & 0xFF;
        }
        t.gen = 0;
        return t.max & 0xFF;
    }

    public IRubyObject tr_s(IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup();
        str.tr_trans(src, repl, true);
        return str;
    }

    public IRubyObject tr_s_bang(IRubyObject src, IRubyObject repl) {
        return this.tr_trans(src, repl, true);
    }

    public IRubyObject each_line(IRubyObject[] args, Block block) {
        RubyString line;
        int p = this.value.begin;
        int pend = p + this.value.realSize;
        int ptr = p;
        int len = this.value.realSize;
        IRubyObject _rsep = Arity.checkArgumentCount(this.getRuntime(), args, 0, 1) == 0 ? this.getRuntime().getGlobalVariables().get("$/") : args[0];
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if (_rsep.isNil()) {
            block.yield(tc, this);
            return this;
        }
        RubyString rsep = RubyString.stringValue(_rsep);
        ByteList rsepValue = rsep.value;
        byte[] strBytes = this.value.bytes;
        int rslen = rsepValue.realSize;
        byte newline = rslen == 0 ? (byte)10 : rsepValue.bytes[rsepValue.begin + rslen - 1];
        int s = p;
        p += rslen;
        while (p < pend) {
            if (rslen == 0 && strBytes[p] == 10) {
                if (strBytes[++p] == 10) {
                    while (strBytes[p] == 10) {
                        ++p;
                    }
                }
            } else if (ptr < p && strBytes[p - 1] == newline && (rslen <= 1 || ByteList.memcmp(rsepValue.bytes, rsepValue.begin, rslen, strBytes, p - rslen, rslen) == 0)) {
                line = RubyString.newStringShared(this.getRuntime(), this.getMetaClass(), this.value.makeShared(s, p - s));
                line.infectBy(this);
                block.yield(tc, line);
                this.modifyCheck(strBytes, len);
                s = p;
            }
            ++p;
        }
        if (s != pend) {
            if (p > pend) {
                p = pend;
            }
            line = RubyString.newStringShared(this.getRuntime(), this.getMetaClass(), this.value.makeShared(s, p - s));
            line.infectBy(this);
            block.yield(tc, line);
        }
        return this;
    }

    public RubyString each_byte(Block block) {
        int lLength = this.value.length();
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        for (int i = 0; i < lLength; ++i) {
            block.yield(context, runtime.newFixnum(this.value.get(i) & 0xFF));
        }
        return this;
    }

    public RubySymbol intern() {
        String s = this.toString();
        if (s.length() == 0) {
            throw this.getRuntime().newArgumentError("interning empty string");
        }
        if (s.indexOf(0) >= 0) {
            throw this.getRuntime().newArgumentError("symbol string may not contain '\\0'");
        }
        return RubySymbol.newSymbol(this.getRuntime(), this.toString());
    }

    public RubySymbol to_sym() {
        return this.intern();
    }

    public RubyInteger sum(IRubyObject[] args) {
        long bitSizeArg;
        if (args.length > 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + args.length + " for 1)");
        }
        long bitSize = 16L;
        if (args.length == 1 && (bitSizeArg = args[0].convertToInteger().getLongValue()) > 0L) {
            bitSize = bitSizeArg;
        }
        long result = 0L;
        for (int i = 0; i < this.value.length(); ++i) {
            result += (long)(this.value.get(i) & 0xFF);
        }
        return this.getRuntime().newFixnum(bitSize == 0L ? result : result % (long)Math.pow(2.0, bitSize));
    }

    public static RubyString unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyString result = RubyString.newString(input.getRuntime(), input.unmarshalString());
        input.registerLinkTarget(result);
        return result;
    }

    public RubyArray unpack(IRubyObject obj) {
        return Pack.unpack(this.getRuntime(), this.value, RubyString.stringValue((IRubyObject)obj).value);
    }

    public void setValue(CharSequence value) {
        this.view(ByteList.plain(value));
    }

    public void setValue(ByteList value) {
        this.view(value);
    }

    public CharSequence getValue() {
        return this.toString();
    }

    public String getUnicodeValue() {
        try {
            return new String(this.value.bytes, this.value.begin, this.value.realSize, "UTF8");
        }
        catch (Exception e) {
            throw new RuntimeException("Something's seriously broken with encodings", e);
        }
    }

    public static byte[] toUTF(String string) {
        try {
            return string.getBytes("UTF8");
        }
        catch (Exception e) {
            throw new RuntimeException("Something's seriously broken with encodings", e);
        }
    }

    public void setUnicodeValue(String newValue) {
        this.view(RubyString.toUTF(newValue));
    }

    public byte[] getBytes() {
        return this.value.bytes();
    }

    public ByteList getByteList() {
        return this.value;
    }

    static {
        $assertionsDisabled = !RubyString.class.desiredAssertionStatus();
        STRING_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                RubyString newString = runtime.newString("");
                newString.setMetaClass(klass);
                return newString;
            }
        };
        SPACE_BYTELIST = new ByteList(ByteList.plain(" "));
        WHITESPACE = new boolean[256];
        RubyString.WHITESPACE[160] = true;
        RubyString.WHITESPACE[137] = true;
        RubyString.WHITESPACE[138] = true;
        RubyString.WHITESPACE[141] = true;
        RubyString.WHITESPACE[140] = true;
    }

    private static final class TR {
        int gen;
        int now;
        int max;
        int p;
        int pend;
        byte[] buf;

        private TR() {
        }
    }

    public static class JavaCrypt {
        private static Random r_gen = new Random();
        private static final char[] theBaseSalts = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '/', '.'};
        private static final int ITERATIONS = 16;
        private static final int[] con_salt = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 0, 0, 0, 0, 0};
        private static final boolean[] shifts2 = new boolean[]{false, false, true, true, true, true, true, true, false, true, true, true, true, true, true, false};
        private static final int[][] skb = new int[][]{{0, 16, 0x20000000, 0x20000010, 65536, 65552, 0x20010000, 0x20010010, 2048, 2064, 0x20000800, 536872976, 67584, 67600, 536938496, 536938512, 32, 48, 0x20000020, 0x20000030, 65568, 65584, 0x20010020, 536936496, 2080, 2096, 0x20000820, 536873008, 67616, 67632, 536938528, 536938544, 524288, 524304, 0x20080000, 537395216, 589824, 589840, 0x20090000, 537460752, 526336, 526352, 0x20080800, 537397264, 591872, 591888, 537462784, 537462800, 524320, 524336, 0x20080020, 537395248, 589856, 589872, 0x20090020, 537460784, 526368, 526384, 0x20080820, 537397296, 591904, 591920, 537462816, 537462832}, {0, 0x2000000, 8192, 0x2002000, 0x200000, 0x2200000, 0x202000, 0x2202000, 4, 0x2000004, 8196, 0x2002004, 0x200004, 0x2200004, 0x202004, 0x2202004, 1024, 0x2000400, 9216, 0x2002400, 0x200400, 0x2200400, 0x202400, 0x2202400, 1028, 0x2000404, 9220, 0x2002404, 0x200404, 0x2200404, 0x202404, 0x2202404, 0x10000000, 0x12000000, 0x10002000, 0x12002000, 0x10200000, 0x12200000, 0x10202000, 0x12202000, 0x10000004, 301989892, 268443652, 301998084, 270532612, 304087044, 270540804, 304095236, 0x10000400, 301990912, 268444672, 301999104, 270533632, 304088064, 270541824, 304096256, 0x10000404, 301990916, 268444676, 301999108, 270533636, 304088068, 270541828, 304096260}, {0, 1, 262144, 262145, 0x1000000, 0x1000001, 0x1040000, 0x1040001, 2, 3, 262146, 262147, 0x1000002, 0x1000003, 17039362, 17039363, 512, 513, 262656, 262657, 0x1000200, 0x1000201, 17039872, 17039873, 514, 515, 262658, 262659, 0x1000202, 16777731, 17039874, 17039875, 0x8000000, 0x8000001, 0x8040000, 134479873, 0x9000000, 0x9000001, 0x9040000, 151257089, 0x8000002, 0x8000003, 134479874, 134479875, 0x9000002, 0x9000003, 151257090, 151257091, 0x8000200, 134218241, 134480384, 134480385, 0x9000200, 150995457, 151257600, 151257601, 0x8000202, 134218243, 134480386, 134480387, 0x9000202, 150995459, 151257602, 151257603}, {0, 0x100000, 256, 0x100100, 8, 0x100008, 264, 0x100108, 4096, 0x101000, 4352, 0x101100, 4104, 0x101008, 4360, 0x101108, 0x4000000, 0x4100000, 0x4000100, 0x4100100, 0x4000008, 68157448, 67109128, 68157704, 0x4001000, 0x4101000, 0x4001100, 0x4101100, 67112968, 68161544, 67113224, 68161800, 131072, 0x120000, 131328, 0x120100, 131080, 1179656, 131336, 1179912, 135168, 0x121000, 135424, 0x121100, 135176, 1183752, 135432, 1184008, 0x4020000, 68288512, 67240192, 68288768, 67239944, 68288520, 67240200, 68288776, 67244032, 68292608, 67244288, 68292864, 67244040, 68292616, 67244296, 68292872}, {0, 0x10000000, 65536, 0x10010000, 4, 0x10000004, 65540, 0x10010004, 0x20000000, 0x30000000, 0x20010000, 0x30010000, 0x20000004, 0x30000004, 536936452, 805371908, 0x100000, 0x10100000, 0x110000, 0x10110000, 0x100004, 0x10100004, 0x110004, 0x10110004, 0x20100000, 0x30100000, 0x20110000, 0x30110000, 537919492, 806354948, 537985028, 806420484, 4096, 0x10001000, 69632, 0x10011000, 4100, 0x10001004, 69636, 0x10011004, 0x20001000, 0x30001000, 0x20011000, 0x30011000, 536875012, 805310468, 536940548, 805376004, 0x101000, 0x10101000, 0x111000, 0x10111000, 0x101004, 0x10101004, 0x111004, 0x10111004, 0x20101000, 0x30101000, 0x20111000, 0x30111000, 537923588, 806359044, 537989124, 806424580}, {0, 0x8000000, 8, 0x8000008, 1024, 0x8000400, 1032, 0x8000408, 131072, 0x8020000, 131080, 0x8020008, 132096, 134349824, 132104, 134349832, 1, 0x8000001, 9, 0x8000009, 1025, 134218753, 1033, 134218761, 131073, 134348801, 131081, 134348809, 132097, 134349825, 132105, 134349833, 0x2000000, 0xA000000, 0x2000008, 0xA000008, 0x2000400, 0xA000400, 33555464, 167773192, 0x2020000, 0xA020000, 0x2020008, 167903240, 0x2020400, 167904256, 33686536, 167904264, 0x2000001, 0xA000001, 0x2000009, 0xA000009, 33555457, 167773185, 33555465, 167773193, 0x2020001, 167903233, 0x2020009, 167903241, 33686529, 167904257, 33686537, 167904265}, {0, 256, 524288, 524544, 0x1000000, 0x1000100, 0x1080000, 0x1080100, 16, 272, 524304, 524560, 0x1000010, 0x1000110, 0x1080010, 0x1080110, 0x200000, 0x200100, 0x280000, 2621696, 0x1200000, 0x1200100, 19398656, 19398912, 0x200010, 0x200110, 2621456, 2621712, 0x1200010, 0x1200110, 19398672, 19398928, 512, 768, 524800, 525056, 0x1000200, 0x1000300, 17302016, 17302272, 528, 784, 524816, 525072, 0x1000210, 0x1000310, 17302032, 17302288, 0x200200, 0x200300, 0x280200, 2622208, 0x1200200, 18875136, 19399168, 19399424, 0x200210, 2097936, 2621968, 2622224, 0x1200210, 18875152, 19399184, 19399440}, {0, 0x4000000, 262144, 0x4040000, 2, 0x4000002, 262146, 0x4040002, 8192, 0x4002000, 270336, 0x4042000, 8194, 0x4002002, 270338, 0x4042002, 32, 0x4000020, 262176, 0x4040020, 34, 0x4000022, 262178, 0x4040022, 8224, 0x4002020, 270368, 0x4042020, 8226, 0x4002022, 270370, 0x4042022, 2048, 0x4000800, 264192, 0x4040800, 2050, 67110914, 264194, 67373058, 10240, 67119104, 272384, 67381248, 10242, 67119106, 272386, 67381250, 2080, 67110944, 264224, 67373088, 2082, 67110946, 264226, 67373090, 10272, 67119136, 272416, 67381280, 10274, 67119138, 272418, 67381282}};
        private static final int[][] SPtrans = new int[][]{{0x820200, 131072, -2139095040, -2138963456, 0x800000, -2147352064, -2147352576, -2139095040, -2147352064, 0x820200, 0x820000, -2147483136, -2139094528, 0x800000, 0, -2147352576, 131072, Integer.MIN_VALUE, 0x800200, 131584, -2138963456, 0x820000, -2147483136, 0x800200, Integer.MIN_VALUE, 512, 131584, -2138963968, 512, -2139094528, -2138963968, 0, 0, -2138963456, 0x800200, -2147352576, 0x820200, 131072, -2147483136, 0x800200, -2138963968, 512, 131584, -2139095040, -2147352064, Integer.MIN_VALUE, -2139095040, 0x820000, -2138963456, 131584, 0x820000, -2139094528, 0x800000, -2147483136, -2147352576, 0, 131072, 0x800000, -2139094528, 0x820200, Integer.MIN_VALUE, -2138963968, 512, -2147352064}, {268705796, 0, 270336, 0x10040000, 0x10000004, 8196, 0x10002000, 270336, 8192, 0x10040004, 4, 0x10002000, 262148, 268705792, 0x10040000, 4, 262144, 268443652, 0x10040004, 8192, 270340, 0x10000000, 0, 262148, 268443652, 270340, 268705792, 0x10000004, 0x10000000, 262144, 8196, 268705796, 262148, 268705792, 0x10002000, 270340, 268705796, 262148, 0x10000004, 0, 0x10000000, 8196, 262144, 0x10040004, 8192, 0x10000000, 270340, 268443652, 268705792, 8192, 0, 0x10000004, 4, 268705796, 270336, 0x10040000, 0x10040004, 262144, 8196, 0x10002000, 268443652, 4, 0x10040000, 270336}, {0x41000000, 0x1010040, 64, 0x41000040, 0x40010000, 0x1000000, 0x41000040, 65600, 0x1000040, 65536, 0x1010000, 0x40000000, 0x41010040, 0x40000040, 0x40000000, 0x41010000, 0, 0x40010000, 0x1010040, 64, 0x40000040, 0x41010040, 65536, 0x41000000, 0x41010000, 0x1000040, 0x40010040, 0x1010000, 65600, 0, 0x1000000, 0x40010040, 0x1010040, 64, 0x40000000, 65536, 0x40000040, 0x40010000, 0x1010000, 0x41000040, 0, 0x1010040, 65600, 0x41010000, 0x40010000, 0x1000000, 0x41010040, 0x40000000, 0x40010040, 0x41000000, 0x1000000, 0x41010040, 65536, 0x1000040, 0x41000040, 65600, 0x1000040, 0, 0x41010000, 0x40000040, 0x41000000, 0x40010040, 64, 0x1010000}, {1049602, 0x4000400, 2, 68158466, 0, 0x4100000, 0x4000402, 0x100002, 0x4100400, 0x4000002, 0x4000000, 1026, 0x4000002, 1049602, 0x100000, 0x4000000, 68157442, 0x100400, 1024, 2, 0x100400, 0x4000402, 0x4100000, 1024, 1026, 0, 0x100002, 0x4100400, 0x4000400, 68157442, 68158466, 0x100000, 68157442, 1026, 0x100000, 0x4000002, 0x100400, 0x4000400, 2, 0x4100000, 0x4000402, 0, 1024, 0x100002, 0, 68157442, 0x4100400, 1024, 0x4000000, 68158466, 1049602, 0x100000, 68158466, 2, 0x4000400, 1049602, 0x100002, 0x100400, 0x4100000, 0x4000402, 1026, 0x4000000, 0x4000002, 0x4100400}, {0x2000000, 16384, 256, 33571080, 33570824, 0x2000100, 16648, 0x2004000, 16384, 8, 0x2000008, 16640, 33554696, 33570824, 33571072, 0, 16640, 0x2000000, 16392, 264, 0x2000100, 16648, 0, 0x2000008, 8, 33554696, 33571080, 16392, 0x2004000, 256, 264, 33571072, 33571072, 33554696, 16392, 0x2004000, 16384, 8, 0x2000008, 0x2000100, 0x2000000, 16640, 33571080, 0, 16648, 0x2000000, 256, 16392, 33554696, 256, 0, 33571080, 33570824, 33571072, 264, 16384, 16640, 33570824, 0x2000100, 264, 8, 16648, 0x2004000, 0x2000008}, {0x20000010, 524304, 0, 0x20080800, 524304, 2048, 536872976, 524288, 2064, 537397264, 526336, 0x20000000, 0x20000800, 0x20000010, 0x20080000, 526352, 524288, 536872976, 537395216, 0, 2048, 16, 0x20080800, 537395216, 537397264, 0x20080000, 0x20000000, 2064, 16, 526336, 526352, 0x20000800, 2064, 0x20000000, 0x20000800, 526352, 0x20080800, 524304, 0, 0x20000800, 0x20000000, 2048, 537395216, 524288, 524304, 537397264, 526336, 16, 537397264, 526336, 524288, 536872976, 0x20000010, 0x20080000, 526352, 0, 2048, 0x20000010, 536872976, 0x20080800, 0x20080000, 2064, 16, 537395216}, {4096, 128, 0x400080, 0x400001, 4198529, 4097, 4224, 0, 0x400000, 4194433, 129, 0x401000, 1, 4198528, 0x401000, 129, 4194433, 4096, 4097, 4198529, 0, 0x400080, 0x400001, 4224, 0x401001, 4225, 4198528, 1, 4225, 0x401001, 128, 0x400000, 4225, 0x401000, 0x401001, 129, 4096, 128, 0x400000, 0x401001, 4194433, 4225, 4224, 0, 128, 0x400001, 1, 0x400080, 0, 4194433, 0x400080, 4224, 129, 4096, 4198529, 0x400000, 4198528, 1, 4097, 4198529, 0x400001, 4198528, 0x401000, 4097}, {0x8200020, 0x8208000, 32800, 0, 0x8008000, 0x200020, 0x8200000, 0x8208020, 32, 0x8000000, 0x208000, 32800, 0x208020, 0x8008020, 0x8000020, 0x8200000, 32768, 0x208020, 0x200020, 0x8008000, 0x8208020, 0x8000020, 0, 0x208000, 0x8000000, 0x200000, 0x8008020, 0x8200020, 0x200000, 32768, 0x8208000, 32, 0x200000, 32768, 0x8000020, 0x8208020, 32800, 0x8000000, 0, 0x208000, 0x8200020, 0x8008020, 0x8008000, 0x200020, 0x8208000, 32, 0x200020, 0x8008000, 0x8208020, 0x200000, 0x8200000, 0x8000020, 0x208000, 32800, 0x8008020, 0x8200000, 32, 0x8208000, 0x208020, 0, 0x8000000, 0x8200020, 32768, 0x208020}};
        private static final int[] cov_2char = new int[]{46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};

        private static final int byteToUnsigned(byte b) {
            return b & 0xFF;
        }

        private static int fourBytesToInt(byte[] b, int offset) {
            int value = JavaCrypt.byteToUnsigned(b[offset++]);
            value |= JavaCrypt.byteToUnsigned(b[offset++]) << 8;
            value |= JavaCrypt.byteToUnsigned(b[offset++]) << 16;
            return value |= JavaCrypt.byteToUnsigned(b[offset++]) << 24;
        }

        private static final void intToFourBytes(int iValue, byte[] b, int offset) {
            b[offset++] = (byte)(iValue & 0xFF);
            b[offset++] = (byte)(iValue >>> 8 & 0xFF);
            b[offset++] = (byte)(iValue >>> 16 & 0xFF);
            b[offset++] = (byte)(iValue >>> 24 & 0xFF);
        }

        private static final void PERM_OP(int a, int b, int n, int m, int[] results) {
            int t = (a >>> n ^ b) & m;
            results[0] = a ^= t << n;
            results[1] = b ^= t;
        }

        private static final int HPERM_OP(int a, int n, int m) {
            int t = (a << 16 - n ^ a) & m;
            a = a ^ t ^ t >>> 16 - n;
            return a;
        }

        private static int[] des_set_key(byte[] key) {
            int[] schedule = new int[32];
            int c = JavaCrypt.fourBytesToInt(key, 0);
            int d = JavaCrypt.fourBytesToInt(key, 4);
            int[] results = new int[2];
            JavaCrypt.PERM_OP(d, c, 4, 0xF0F0F0F, results);
            d = results[0];
            c = results[1];
            c = JavaCrypt.HPERM_OP(c, -2, -859045888);
            d = JavaCrypt.HPERM_OP(d, -2, -859045888);
            JavaCrypt.PERM_OP(d, c, 1, 0x55555555, results);
            d = results[0];
            c = results[1];
            JavaCrypt.PERM_OP(c, d, 8, 0xFF00FF, results);
            c = results[0];
            d = results[1];
            JavaCrypt.PERM_OP(d, c, 1, 0x55555555, results);
            d = results[0];
            c = results[1];
            d = (d & 0xFF) << 16 | d & 0xFF00 | (d & 0xFF0000) >>> 16 | (c & 0xF0000000) >>> 4;
            c &= 0xFFFFFFF;
            int j = 0;
            for (int i = 0; i < 16; ++i) {
                if (shifts2[i]) {
                    c = c >>> 2 | c << 26;
                    d = d >>> 2 | d << 26;
                } else {
                    c = c >>> 1 | c << 27;
                    d = d >>> 1 | d << 27;
                }
                int s = skb[0][(c &= 0xFFFFFFF) & 0x3F] | skb[1][c >>> 6 & 3 | c >>> 7 & 0x3C] | skb[2][c >>> 13 & 0xF | c >>> 14 & 0x30] | skb[3][c >>> 20 & 1 | c >>> 21 & 6 | c >>> 22 & 0x38];
                int t = skb[4][(d &= 0xFFFFFFF) & 0x3F] | skb[5][d >>> 7 & 3 | d >>> 8 & 0x3C] | skb[6][d >>> 15 & 0x3F] | skb[7][d >>> 21 & 0xF | d >>> 22 & 0x30];
                schedule[j++] = (t << 16 | s & 0xFFFF) & 0xFFFFFFFF;
                s = s >>> 16 | t & 0xFFFF0000;
                s = s << 4 | s >>> 28;
                schedule[j++] = s & 0xFFFFFFFF;
            }
            return schedule;
        }

        private static final int D_ENCRYPT(int L, int R, int S, int E0, int E1, int[] s) {
            int v = R ^ R >>> 16;
            int u = v & E0;
            u = u ^ u << 16 ^ R ^ s[S];
            int t = (v &= E1) ^ v << 16 ^ R ^ s[S + 1];
            t = t >>> 4 | t << 28;
            return L ^= SPtrans[1][t & 0x3F] | SPtrans[3][t >>> 8 & 0x3F] | SPtrans[5][t >>> 16 & 0x3F] | SPtrans[7][t >>> 24 & 0x3F] | SPtrans[0][u & 0x3F] | SPtrans[2][u >>> 8 & 0x3F] | SPtrans[4][u >>> 16 & 0x3F] | SPtrans[6][u >>> 24 & 0x3F];
        }

        private static final int[] body(int[] schedule, int Eswap0, int Eswap1) {
            int left = 0;
            int right = 0;
            int t = 0;
            for (int j = 0; j < 25; ++j) {
                for (int i = 0; i < 32; i += 4) {
                    left = JavaCrypt.D_ENCRYPT(left, right, i, Eswap0, Eswap1, schedule);
                    right = JavaCrypt.D_ENCRYPT(right, left, i + 2, Eswap0, Eswap1, schedule);
                }
                t = left;
                left = right;
                right = t;
            }
            t = right;
            right = left >>> 1 | left << 31;
            left = t >>> 1 | t << 31;
            int[] results = new int[2];
            JavaCrypt.PERM_OP(right &= 0xFFFFFFFF, left &= 0xFFFFFFFF, 1, 0x55555555, results);
            right = results[0];
            left = results[1];
            JavaCrypt.PERM_OP(left, right, 8, 0xFF00FF, results);
            left = results[0];
            right = results[1];
            JavaCrypt.PERM_OP(right, left, 2, 0x33333333, results);
            right = results[0];
            left = results[1];
            JavaCrypt.PERM_OP(left, right, 16, 65535, results);
            left = results[0];
            right = results[1];
            JavaCrypt.PERM_OP(right, left, 4, 0xF0F0F0F, results);
            right = results[0];
            left = results[1];
            int[] out = new int[]{left, right};
            return out;
        }

        public static final String crypt(String salt, String original) {
            int i;
            while (salt.length() < 2) {
                salt = salt + JavaCrypt.getSaltChar();
            }
            StringBuffer buffer = new StringBuffer("             ");
            char charZero = salt.charAt(0);
            char charOne = salt.charAt(1);
            buffer.setCharAt(0, charZero);
            buffer.setCharAt(1, charOne);
            int Eswap0 = con_salt[charZero];
            int Eswap1 = con_salt[charOne] << 4;
            byte[] key = new byte[8];
            for (i = 0; i < key.length; ++i) {
                key[i] = 0;
            }
            for (i = 0; i < key.length && i < original.length(); ++i) {
                char iChar = original.charAt(i);
                key[i] = (byte)(iChar << 1);
            }
            int[] schedule = JavaCrypt.des_set_key(key);
            int[] out = JavaCrypt.body(schedule, Eswap0, Eswap1);
            byte[] b = new byte[9];
            JavaCrypt.intToFourBytes(out[0], b, 0);
            JavaCrypt.intToFourBytes(out[1], b, 4);
            b[8] = 0;
            int y = 0;
            int u = 128;
            for (int i2 = 2; i2 < 13; ++i2) {
                int c = 0;
                for (int j = 0; j < 6; ++j) {
                    c <<= 1;
                    if ((b[y] & u) != 0) {
                        c |= 1;
                    }
                    if ((u >>>= 1) == 0) {
                        ++y;
                        u = 128;
                    }
                    buffer.setCharAt(i2, (char)cov_2char[c]);
                }
            }
            return buffer.toString();
        }

        private static String getSaltChar() {
            return JavaCrypt.getSaltChar(1);
        }

        private static String getSaltChar(int amount) {
            StringBuffer sb = new StringBuffer();
            for (int i = amount; i > 0; --i) {
                sb.append(theBaseSalts[Math.abs(r_gen.nextInt()) % 64]);
            }
            return sb.toString();
        }

        public static boolean check(String theClear, String theCrypt) {
            String theTest = JavaCrypt.crypt(theCrypt.substring(0, 2), theClear);
            return theTest.equals(theCrypt);
        }

        public static String crypt(String theClear) {
            return JavaCrypt.crypt(JavaCrypt.getSaltChar(2), theClear);
        }
    }
}

