/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.lifecycle.LifeCycleState;
import org.nuxeo.ecm.core.lifecycle.extensions.LifeCycleDescriptor;
import org.nuxeo.ecm.core.lifecycle.extensions.LifeCycleTypesDescriptor;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeCycleServiceImpl
extends DefaultComponent
implements LifeCycleService {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.lifecycle.LifeCycleService");
    private static final Log log = LogFactory.getLog(LifeCycleServiceImpl.class);
    private final Map<String, LifeCycle> lifeCycles = new HashMap<String, LifeCycle>();
    private final Map<String, String> typesMapping = new HashMap<String, String>();

    @Override
    public LifeCycle getLifeCycleByName(String name) {
        return this.lifeCycles.get(name);
    }

    @Override
    public LifeCycle getLifeCycleFor(Document doc) {
        String lifeCycleName = this.getLifeCycleNameFor(doc.getType().getName());
        return this.getLifeCycleByName(lifeCycleName);
    }

    @Override
    public String getLifeCycleNameFor(String typeName) {
        return this.typesMapping.get(typeName);
    }

    @Override
    public Collection<LifeCycle> getLifeCycles() {
        return this.lifeCycles.values();
    }

    @Override
    public Collection<String> getTypesFor(String lifeCycleName) {
        ArrayList<String> types = new ArrayList<String>();
        for (String typeName : this.typesMapping.keySet()) {
            if (!this.typesMapping.get(typeName).equals(lifeCycleName)) continue;
            types.add(typeName);
        }
        return types;
    }

    @Override
    public Map<String, String> getTypesMapping() {
        return this.typesMapping;
    }

    @Override
    public void initialize(Document doc) throws LifeCycleException {
        this.initialize(doc, null);
    }

    @Override
    public void initialize(Document doc, String initialStateName) throws LifeCycleException {
        String lifeCycleName;
        LifeCycle documentLifeCycle = this.getLifeCycleFor(doc);
        if (documentLifeCycle == null) {
            lifeCycleName = "undefined";
            if (initialStateName == null) {
                initialStateName = "undefined";
            }
        } else {
            lifeCycleName = documentLifeCycle.getName();
            if (initialStateName == null) {
                initialStateName = documentLifeCycle.getDefaultInitialStateName();
            } else {
                LifeCycleState state = documentLifeCycle.getStateByName(initialStateName);
                if (state == null) {
                    throw new LifeCycleException(String.format("State '%s' is not a valid state for lifecycle %s", initialStateName, lifeCycleName));
                }
                if (!documentLifeCycle.getInitialStateNames().contains(initialStateName)) {
                    log.warn((Object)String.format("State '%s' is not a valid initial state for lifecycle %s", initialStateName, lifeCycleName));
                }
            }
        }
        doc.setCurrentLifeCycleState(initialStateName);
        doc.setLifeCyclePolicy(lifeCycleName);
    }

    @Override
    public void followTransition(Document doc, String transitionName) throws LifeCycleException {
        String currentStateName = doc.getCurrentLifeCycleState();
        LifeCycle lifeCycle = this.getLifeCycleFor(doc);
        if (!lifeCycle.getAllowedStateTransitionsFrom(currentStateName).contains(transitionName)) {
            throw new LifeCycleException("Not allowed to follow transition <" + transitionName + "> from state <" + currentStateName + '>');
        }
        String destinationStateName = lifeCycle.getTransitionByName(transitionName).getDestinationStateName();
        doc.setCurrentLifeCycleState(destinationStateName);
    }

    @Override
    public void reinitLifeCycle(Document doc) throws LifeCycleException {
        LifeCycle documentLifeCycle = this.getLifeCycleFor(doc);
        if (documentLifeCycle == null) {
            log.debug((Object)"No lifecycle policy for this document. Nothing to do !");
            return;
        }
        doc.setCurrentLifeCycleState(documentLifeCycle.getDefaultInitialStateName());
    }

    public void registerExtension(Extension extension) throws Exception {
        block2: {
            String point;
            Object[] contributions;
            block4: {
                block3: {
                    contributions = extension.getContributions();
                    if (contributions == null) break block2;
                    point = extension.getExtensionPoint();
                    if (!point.equals("lifecycle")) break block3;
                    for (Object contribution : contributions) {
                        LifeCycleDescriptor desc = (LifeCycleDescriptor)contribution;
                        log.info((Object)("Registering lifecycle: " + desc.getName()));
                        this.lifeCycles.put(desc.getName(), desc.getLifeCycle());
                    }
                    break block2;
                }
                if (!point.equals("lifecyclemanager")) break block4;
                log.warn((Object)"Ignoring deprecated lifecyclemanager extension point");
                break block2;
            }
            if (!point.equals("types")) break block2;
            for (Object mapping : contributions) {
                LifeCycleTypesDescriptor desc = (LifeCycleTypesDescriptor)mapping;
                log.info((Object)("Registering lifecycle types mapping: " + desc.getTypesMapping()));
                this.typesMapping.putAll(desc.getTypesMapping());
            }
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        block3: {
            String point;
            Object[] contributions;
            block4: {
                super.unregisterExtension(extension);
                contributions = extension.getContributions();
                if (contributions == null) break block3;
                point = extension.getExtensionPoint();
                if (!point.equals("lifecycle")) break block4;
                for (Object lifeCycle : contributions) {
                    LifeCycleDescriptor lifeCycleDescriptor = (LifeCycleDescriptor)lifeCycle;
                    log.debug((Object)("Unregistering lifecycle: " + lifeCycleDescriptor.getName()));
                    this.lifeCycles.remove(lifeCycleDescriptor.getName());
                }
                break block3;
            }
            if (!point.equals("types")) break block3;
            for (Object contrib : contributions) {
                LifeCycleTypesDescriptor desc = (LifeCycleTypesDescriptor)contrib;
                for (String typeName : desc.getTypesMapping().keySet()) {
                    this.typesMapping.remove(typeName);
                }
            }
        }
    }
}

