/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.repository;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.model.NoSuchRepositoryException;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.repository.JBossRepositoryMBean;

public class JBossRepository
implements JBossRepositoryMBean {
    protected final String name;

    public JBossRepository(String name) {
        this.name = name;
    }

    public Repository getRepository() throws NoSuchRepositoryException {
        return NXCore.getRepository(this.name);
    }

    public String listDocumentLocks() {
        return "Not Implemented";
    }

    public String listOpenedSessions() throws NoSuchRepositoryException, DocumentException {
        Repository repo = this.getRepository();
        Session[] sessions = repo.getOpenedSessions();
        StringBuilder buf = new StringBuilder();
        buf.append("<b>Started sessions count: </b>").append(repo.getStartedSessionsCount()).append("<br>");
        buf.append("<b>Closed sessions count: </b>").append(repo.getClosedSessionsCount()).append("<br>");
        buf.append("<b>Active sessions count: </b>").append(repo.getActiveSessionsCount()).append("<br>");
        buf.append("<ol>");
        for (Session session : sessions) {
            Map<String, Serializable> ctx = session.getSessionContext();
            buf.append("<li>").append("Session #").append(session.getSessionId()).append("; principal: ").append(ctx.get("principal")).append("; ctime: ").append(new Date((Long)ctx.get("creationTime")));
        }
        buf.append("</ol>");
        return buf.toString();
    }

    public String listRegisteredDocumentTypes() {
        return null;
    }

    public String listRegisteredSchemas() {
        return null;
    }

    public String listRegisteredTypes() {
        return null;
    }

    public void restart(boolean reloadTypes) {
    }
}

