/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.repository.RepositoryDescriptor;
import org.nuxeo.ecm.core.repository.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryManager {
    public static final String REPOSITORY_EVENT = "repository";
    private static final Log log = LogFactory.getLog(RepositoryManager.class);
    private final Set<RepositoryDescriptor> descriptors = new HashSet<RepositoryDescriptor>();
    private final Map<String, Ref> repositories = new HashMap<String, Ref>();
    private final RepositoryService repositoryService;

    public RepositoryManager(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(String name) throws Exception {
        Ref ref;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Entering getRepository : " + name));
        }
        Map<String, Ref> map = this.repositories;
        synchronized (map) {
            ref = this.repositories.get(name);
        }
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRepository(String name) {
        Ref ref;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Entering releaseRepository : " + name));
        }
        Map<String, Ref> map = this.repositories;
        synchronized (map) {
            ref = this.repositories.remove(name);
        }
        if (ref != null) {
            ref.release();
        }
    }

    public Collection<RepositoryDescriptor> getDescriptors() {
        return Collections.unmodifiableCollection(this.descriptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRepositoryNames() {
        Map<String, Ref> map = this.repositories;
        synchronized (map) {
            return this.repositories.keySet().toArray(new String[this.repositories.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryDescriptor getDescriptor(String name) {
        Map<String, Ref> map = this.repositories;
        synchronized (map) {
            Ref ref = this.repositories.get(name);
            if (ref != null) {
                return ref.descriptor;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRepository(RepositoryDescriptor rd) {
        log.info((Object)("Registering repository: " + rd.getName()));
        if (!this.descriptors.contains(rd)) {
            Map<String, Ref> map = this.repositories;
            synchronized (map) {
                if (!this.descriptors.contains(rd)) {
                    String name = rd.getName();
                    this.descriptors.add(rd);
                    this.repositories.put(name, new Ref(rd));
                    this.repositoryService.fireRepositoryRegistered(rd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getOrRegisterRepository(RepositoryDescriptor rd) throws Exception {
        Map<String, Ref> map = this.repositories;
        synchronized (map) {
            Ref ref = this.repositories.get(rd.getName());
            if (ref == null) {
                String name = rd.getName();
                log.info((Object)("Registering repository: " + name));
                this.descriptors.add(rd);
                ref = new Ref(rd);
                this.repositories.put(name, ref);
                this.repositoryService.fireRepositoryRegistered(rd);
            }
            return ref.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterRepository(RepositoryDescriptor rd) {
        log.info((Object)("Unregistering repository: " + rd.getName()));
        if (this.descriptors.contains(rd)) {
            Map<String, Ref> map = this.repositories;
            synchronized (map) {
                this.descriptors.remove(rd);
                Ref ref = this.repositories.remove(rd.getName());
                if (ref != null) {
                    log.info((Object)("Unregistering repository: " + rd.getName()));
                    this.repositoryService.fireRepositoryUnRegistered(rd);
                    ref.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info((Object)"Shutting down repository manager");
        Map<String, Ref> map = this.repositories;
        synchronized (map) {
            Iterator<Ref> it = this.repositories.values().iterator();
            while (it.hasNext()) {
                Ref ref = it.next();
                ref.dispose();
                it.remove();
            }
            this.descriptors.clear();
        }
    }

    public static final class Ref {
        private int refcnt;
        private RepositoryDescriptor descriptor;
        private Repository repository;

        private Ref(RepositoryDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public synchronized Repository get() throws Exception {
            if (this.repository == null) {
                this.refcnt = 0;
                this.repository = this.descriptor.create();
            }
            ++this.refcnt;
            return this.repository;
        }

        public synchronized void release() {
            if (this.repository != null && --this.refcnt == 0) {
                this.repository.shutdown();
                this.repository = null;
            }
        }

        public void dispose() {
            if (this.repository != null) {
                this.repository.shutdown();
                this.repository = null;
            }
            this.refcnt = 0;
            this.descriptor = null;
        }
    }
}

