/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.client;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.nuxeo.osgi.application.client.NuxeoApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher
implements Runnable {
    public void addProperties(Hashtable<String, String> props) {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    protected static File getLibDir() throws Exception {
        String path = "";
        File file = null;
        URL url = Launcher.class.getClassLoader().getResource("target/classes/lib/osgi-core-4.1.jar");
        if (url != null) {
            path = url.getPath();
            file = new File(path).getParentFile();
        } else {
            url = Launcher.class.getClassLoader().getResource("lib/osgi-core-4.1.jar");
            path = url.getPath();
            file = new File(path).getParentFile();
        }
        return file;
    }

    public static Collection<File> getBundles() throws Exception {
        ArrayList<File> bundles = new ArrayList<File>();
        File libDir = Launcher.getLibDir();
        for (String name : libDir.list()) {
            if (!name.startsWith("nuxeo-") || name.contains("osgi") || name.contains(".jar-")) continue;
            bundles.add(new File(libDir, name));
        }
        return bundles;
    }

    protected static File setProperties() throws IOException {
        System.setProperty("org.nuxeo.runtime.streaming.isServer", "false");
        System.setProperty("org.nuxeo.runtime.server.enabled", "false");
        File home = File.createTempFile("nuxeo-", ".tmp");
        home.delete();
        home.mkdirs();
        home.deleteOnExit();
        return home;
    }

    protected static NuxeoApp setup() throws Exception {
        File home = Launcher.setProperties();
        System.setProperty("nuxeo.runner", Launcher.class.getName());
        return new NuxeoApp(home, Launcher.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        NuxeoApp app = Launcher.setup();
        Collection<File> bundles = Launcher.getBundles();
        app.start();
        if (bundles != null) {
            app.deployBundles(bundles);
        }
        ClassLoader cl = app.getLoader();
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            String main = System.getProperty("nuxeo.runner");
            if (main == null) {
                throw new Error("No runnable specified");
            }
            Class<?> mc = app.getLoader().loadClass(main);
            Method m = mc.getMethod("run", new Class[0]);
            m.invoke(mc.newInstance(), new Object[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcl);
            app.shutdown();
        }
    }

    @Override
    public void run() {
    }
}

