/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.api.login;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfoCallback;

public class UserIdentificationInfoCallbackHandler
implements CallbackHandler {
    protected final UserIdentificationInfo userIdent;

    public UserIdentificationInfoCallbackHandler(UserIdentificationInfo userIdent) {
        this.userIdent = userIdent;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback c : callbacks) {
            if (c instanceof NameCallback) {
                String username = this.userIdent.getUserName();
                NameCallback nc = (NameCallback)c;
                nc.setName(username);
                continue;
            }
            if (c instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)c;
                char[] password = this.userIdent.getPassword().toCharArray();
                pc.setPassword(password);
                continue;
            }
            if (c instanceof UserIdentificationInfoCallback) {
                UserIdentificationInfoCallback uic = (UserIdentificationInfoCallback)c;
                uic.setUserInfo(this.userIdent);
                continue;
            }
            if (c.getClass().getName().equals("org.jboss.security.auth.callback.SecurityAssociationCallback")) continue;
            throw new UnsupportedCallbackException(c, "Unrecognized Callback:" + c.getClass().getName());
        }
    }
}

