/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jndi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.naming.NamingContextFactory;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.jndi.SecurityAssociationActions;

public class JndiLoginInitialContextFactory
extends NamingContextFactory {
    public Context getInitialContext(Hashtable env) throws NamingException {
        Object credentials = env.get("java.naming.security.credentials");
        Object principal = env.get("java.naming.security.principal");
        Principal securityPrincipal = null;
        String flag = (String)env.get("jnp.multi-threaded");
        if (Boolean.valueOf(flag).booleanValue()) {
            SecurityAssociationActions.setServer();
        }
        boolean restoreLoginIdentity = false;
        flag = (String)env.get("jnp.restoreLoginIdentity");
        if (flag != null) {
            restoreLoginIdentity = Boolean.parseBoolean(flag);
        }
        if (principal instanceof Principal) {
            securityPrincipal = (Principal)principal;
        } else {
            String username = principal.toString();
            securityPrincipal = new SimplePrincipal(username);
        }
        if (restoreLoginIdentity) {
            SecurityAssociationActions.setPrincipalInfo(securityPrincipal, credentials, null);
        } else {
            SecurityAssociationActions.setPrincipalInfo(securityPrincipal, credentials);
        }
        Context iniCtx = super.getInitialContext(env);
        if (restoreLoginIdentity) {
            ClassLoader loader = SecurityAssociationActions.getContextClassLoader();
            ContextProxy handler = new ContextProxy(iniCtx);
            Class[] ifaces = new Class[]{Context.class};
            iniCtx = (Context)Proxy.newProxyInstance(loader, ifaces, (InvocationHandler)handler);
        }
        return iniCtx;
    }

    public static class ContextProxy
    implements InvocationHandler {
        private Context delegate;

        ContextProxy(Context delegate) {
            this.delegate = delegate;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object object;
            boolean close = false;
            try {
                try {
                    close = method.getName().equals("close");
                    object = method.invoke((Object)this.delegate, args);
                    Object var7_7 = null;
                    if (!close) return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (!close) throw throwable;
                try {
                    SecurityAssociationActions.popPrincipalInfo();
                    throw throwable;
                }
                catch (Throwable ignore) {
                    throw throwable;
                }
            }
            try {}
            catch (Throwable ignore) {
                // empty catch block
                return object;
            }
            SecurityAssociationActions.popPrincipalInfo();
            return object;
        }
    }
}

