/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.versioning.VersionRemovalPolicy;

public class DefaultVersionRemovalPolicy
implements VersionRemovalPolicy {
    private static final Log log = LogFactory.getLog(DefaultVersionRemovalPolicy.class);

    @Override
    public void removeVersions(Session session, Document doc, CoreSession coreSession) throws ClientException {
        try {
            if (session.getProxies(doc, null).isEmpty()) {
                List<String> versionsIds = doc.getVersionsIds();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Removing %s versions for: %s", versionsIds.size(), doc.getUUID()));
                }
                for (String id : versionsIds) {
                    log.debug((Object)("Removing version: " + id));
                    coreSession.removeDocument((DocumentRef)new IdRef(id));
                }
            }
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }
}

