/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.ReconnectedEventBundleImpl;
import org.nuxeo.ecm.core.event.jmx.EventStatsHolder;
import org.nuxeo.ecm.core.event.tx.EventBundleTransactionHandler;
import org.nuxeo.runtime.api.Framework;

public class AsyncEventExecutor {
    private static final Log log = LogFactory.getLog(AsyncEventExecutor.class);
    public static final int QUEUE_SIZE = Integer.MAX_VALUE;
    protected final ThreadPoolExecutor executor;
    protected final BlockingQueue<Runnable> queue;
    protected final ThreadPoolExecutor mono_executor;
    protected final BlockingQueue<Runnable> mono_queue;

    public static AsyncEventExecutor create() {
        String val = Framework.getProperty((String)"org.nuxeo.ecm.core.event.async.poolSize");
        int poolSize = val == null ? 4 : Integer.parseInt(val);
        val = Framework.getProperty((String)"org.nuxeo.ecm.core.event.async.maxPoolSize");
        int maxPoolSize = val == null ? 16 : Integer.parseInt(val);
        val = Framework.getProperty((String)"org.nuxeo.ecm.core.event.async.keepAliveTime");
        int keepAliveTime = val == null ? 0 : Integer.parseInt(val);
        val = Framework.getProperty((String)"org.nuxeo.ecm.core.event.async.queueSize");
        int queueSize = val == null ? Integer.MAX_VALUE : Integer.parseInt(val);
        return new AsyncEventExecutor(poolSize, maxPoolSize, keepAliveTime, queueSize);
    }

    public AsyncEventExecutor(int poolSize, int maxPoolSize, int keepAliveTime, int queueSize) {
        this.queue = new LinkedBlockingQueue<Runnable>(queueSize);
        this.mono_queue = new LinkedBlockingQueue<Runnable>(queueSize);
        NamedThreadFactory threadFactory = new NamedThreadFactory("Nuxeo Async Events");
        this.executor = new ThreadPoolExecutor(poolSize, maxPoolSize, (long)keepAliveTime, TimeUnit.SECONDS, this.queue, threadFactory);
        this.mono_executor = new ThreadPoolExecutor(1, 1, (long)keepAliveTime, TimeUnit.SECONDS, this.mono_queue, threadFactory);
    }

    public void run(List<EventListenerDescriptor> listeners, EventBundle event) {
        this.executor.prestartAllCoreThreads();
        for (EventListenerDescriptor listener : listeners) {
            if (listener.isSingleThreaded()) {
                this.mono_executor.execute(new Job(listener, event));
                continue;
            }
            this.executor.execute(new Job(listener, event));
        }
    }

    public int getUnfinishedCount() {
        return this.executor.getQueue().size() + this.executor.getActiveCount() + this.mono_executor.getQueue().size() + this.mono_executor.getActiveCount();
    }

    public int getActiveCount() {
        return this.executor.getActiveCount() + this.mono_executor.getActiveCount();
    }

    public int getMaxPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    public void setMaxPoolSize(int maxSize) {
        int coreSize = this.executor.getCorePoolSize();
        if (coreSize > maxSize) {
            // empty if block
        }
        this.executor.getMaximumPoolSize();
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger();
        private final AtomicInteger threadNumber = new AtomicInteger();
        private final ThreadGroup group;
        private final String namePrefix;

        public NamedThreadFactory(String prefix) {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup();
            this.namePrefix = prefix + ' ' + poolNumber.incrementAndGet() + '-';
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.namePrefix + this.threadNumber.incrementAndGet();
            Thread t = new Thread(this.group, r, name);
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }

    protected static class Job
    implements Runnable {
        protected final ReconnectedEventBundle bundle;
        protected final EventListenerDescriptor listener;

        public Job(EventListenerDescriptor listener, EventBundle bundle) {
            this.listener = listener;
            this.bundle = bundle instanceof ReconnectedEventBundle ? (ReconnectedEventBundle)bundle : new ReconnectedEventBundleImpl(bundle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EventBundleTransactionHandler txh = new EventBundleTransactionHandler();
            try {
                long t0 = System.currentTimeMillis();
                txh.beginNewTransaction(this.listener.getTransactionTimeout());
                this.listener.asPostCommitListener().handleEvent(this.bundle);
                txh.commitOrRollbackTransaction();
                EventStatsHolder.logAsyncExec(this.listener, System.currentTimeMillis() - t0);
                log.debug((Object)"Async listener executed, commited tx");
            }
            catch (Throwable t) {
                log.error((Object)("Failed to execute async event " + this.bundle.getName() + " on listener " + this.listener.getName()), t);
                txh.rollbackTransaction();
            }
            finally {
                this.bundle.disconnect();
            }
        }
    }
}

