/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.script;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.nuxeo.ecm.core.event.script.Script;
import org.osgi.framework.Bundle;

public class URLScript
extends Script {
    protected final URL url;
    protected URLConnection conn;

    public URLScript(URL url) throws IOException {
        this.url = url;
        this.conn = url.openConnection();
    }

    public URLScript(String location) throws IOException {
        this(new URL(location));
    }

    public URLScript(Bundle bundle, String path) throws IOException {
        this(bundle.getEntry(path));
    }

    @Override
    public String getExtension() {
        return this.getExtension(this.url.getPath());
    }

    @Override
    public String getLocation() {
        return this.url.toExternalForm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getReaderIfModified() throws IOException {
        URLConnection conn = this.url.openConnection();
        long tm = conn.getLastModified();
        if (tm > this.lastModified) {
            URLScript uRLScript = this;
            synchronized (uRLScript) {
                if (tm > this.lastModified) {
                    this.lastModified = tm;
                    return new InputStreamReader(conn.getInputStream());
                }
            }
        }
        return null;
    }

    @Override
    public Reader getReader() throws IOException {
        try {
            return new InputStreamReader(this.conn.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

