/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.CallNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NodeCompilerFactory;
import org.jruby.compiler.NotCompilableException;
import org.jruby.runtime.CallType;

public class CallNodeCompiler
implements NodeCompiler {
    public void compile(Node node, Compiler context) {
        context.lineNumber(node.getPosition());
        CallNode callNode = (CallNode)node;
        if (NodeCompilerFactory.SAFE && NodeCompilerFactory.UNSAFE_CALLS.contains(callNode.getName())) {
            throw new NotCompilableException("Can't compile call safely: " + node);
        }
        if (callNode.getIterNode() == null) {
            NodeCompilerFactory.getCompiler(callNode.getReceiverNode()).compile(callNode.getReceiverNode(), context);
            if (callNode.getArgsNode() != null) {
                NodeCompiler argsCompiler = NodeCompilerFactory.getArgumentsCompiler(callNode.getArgsNode());
                argsCompiler.compile(callNode.getArgsNode(), context);
                context.invokeDynamic(callNode.getName(), true, true, CallType.NORMAL, null, false);
            } else {
                context.invokeDynamic(callNode.getName(), true, false, CallType.NORMAL, null, false);
            }
        } else {
            final IterNode iterNode = (IterNode)callNode.getIterNode();
            ClosureCallback closureArg = new ClosureCallback(){

                public void compile(Compiler context) {
                    NodeCompilerFactory.getCompiler(iterNode).compile(iterNode, context);
                }
            };
            NodeCompilerFactory.getCompiler(callNode.getReceiverNode()).compile(callNode.getReceiverNode(), context);
            if (callNode.getArgsNode() != null) {
                NodeCompiler argsCompiler = NodeCompilerFactory.getArgumentsCompiler(callNode.getArgsNode());
                argsCompiler.compile(callNode.getArgsNode(), context);
                context.invokeDynamic(callNode.getName(), true, true, CallType.NORMAL, closureArg, false);
            } else {
                context.invokeDynamic(callNode.getName(), true, false, CallType.NORMAL, closureArg, false);
            }
        }
    }
}

