/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.FileUtils;

public class TextTemplate {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([a-zA-Z_0-9\\-\\.]+)\\}");
    private final Properties vars;
    private boolean trim = false;

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public TextTemplate() {
        this.vars = new Properties();
    }

    public TextTemplate(Map<String, String> vars) {
        this.vars = new Properties();
        this.vars.putAll(vars);
    }

    public TextTemplate(Properties vars) {
        this.vars = vars;
    }

    public void setVariables(Map<String, String> vars) {
        this.vars.putAll(vars);
    }

    public void setVariable(String name, String value) {
        this.vars.setProperty(name, value);
    }

    public String getVariable(String name) {
        return this.vars.getProperty(name);
    }

    public Properties getVariables() {
        return this.vars;
    }

    public String process(CharSequence text) {
        Matcher m = PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            String value = this.getVariable(var);
            if (value == null) continue;
            if (this.trim) {
                value = value.trim();
            }
            String valueL = Matcher.quoteReplacement(value);
            m.appendReplacement(sb, valueL);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String process(InputStream in) throws IOException {
        String text = FileUtils.read(in);
        return this.process(text);
    }

    public void process(InputStream in, OutputStream out) throws IOException {
        String text = FileUtils.read(in);
        out.write(this.process(text).getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDirectory(File in, File out) throws FileNotFoundException, IOException {
        if (in.isFile()) {
            if (out.isDirectory()) {
                out = new File(out, in.getName());
            }
            FileInputStream is = null;
            FileOutputStream os = new FileOutputStream(out);
            try {
                is = new FileInputStream(in);
                this.process(is, os);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                os.close();
            }
        } else if (in.isDirectory()) {
            if (!out.exists()) {
                out.mkdirs();
            } else if (!out.getName().equals(in.getName())) {
                out = new File(out, in.getName());
                out.mkdir();
            }
            for (File file : in.listFiles()) {
                this.processDirectory(file, out);
            }
        }
    }
}

