/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static void _putDirectoryEntry(String entryName, ZipOutputStream out) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName + '/');
        out.putNextEntry(zentry);
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _putFileEntry(File file, String entryName, ZipOutputStream out) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            ZipUtils._zip(entryName, in, out);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void _zip(String entryName, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName);
        out.putNextEntry(zentry);
        FileUtils.copy(in, out);
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _zip(String entryName, File file, ZipOutputStream out) throws IOException {
        if (file.isDirectory()) {
            entryName = entryName + '/';
            ZipEntry zentry = new ZipEntry(entryName);
            out.putNextEntry(zentry);
            out.closeEntry();
            File[] files = file.listFiles();
            int len = files.length;
            for (int i = 0; i < len; ++i) {
                ZipUtils._zip(entryName + files[i].getName(), files[i], out);
            }
        } else {
            InputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(file));
                ZipUtils._zip(entryName, in, out);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    public static void _zip(File[] files, ZipOutputStream out, String prefix) throws IOException {
        if (prefix != null) {
            int len = prefix.length();
            if (len == 0) {
                prefix = null;
            } else if (prefix.charAt(len - 1) != '/') {
                prefix = prefix + '/';
            }
        }
        int len = files.length;
        for (int i = 0; i < len; ++i) {
            String name = prefix != null ? prefix + files[i].getName() : files[i].getName();
            ZipUtils._zip(name, files[i], out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File file, OutputStream out, String prefix) throws IOException {
        if (prefix != null) {
            int len = prefix.length();
            if (len == 0) {
                prefix = null;
            } else if (prefix.charAt(len - 1) != '/') {
                prefix = prefix + '/';
            }
        }
        String name = prefix != null ? prefix + file.getName() : file.getName();
        ZipOutputStream zout = null;
        try {
            zout = new ZipOutputStream(out);
            ZipUtils._zip(name, file, zout);
        }
        finally {
            if (zout != null) {
                zout.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File[] files, OutputStream out, String prefix) throws IOException {
        ZipOutputStream zout = null;
        try {
            zout = new ZipOutputStream(out);
            ZipUtils._zip(files, zout, prefix);
        }
        finally {
            if (zout != null) {
                zout.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File file, File zip) throws IOException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(zip));
            ZipUtils.zip(file, out, null);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File[] files, File zip) throws IOException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(zip));
            ZipUtils.zip(files, out, null);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File file, File zip, String prefix) throws IOException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(zip));
            ZipUtils.zip(file, out, prefix);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File[] files, File zip, String prefix) throws IOException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(zip));
            ZipUtils.zip(files, out, prefix);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFilesUsingPrefix(String prefix, File[] files, OutputStream out) throws IOException {
        ZipOutputStream zout = null;
        try {
            zout = new ZipOutputStream(out);
            if (prefix != null && prefix.length() > 0) {
                int p = prefix.indexOf(47);
                while (p > -1) {
                    ZipUtils._putDirectoryEntry(prefix.substring(0, p), zout);
                    p = prefix.indexOf(p + 1, 47);
                }
                ZipUtils._putDirectoryEntry(prefix, zout);
                prefix = prefix + '/';
            } else {
                prefix = "";
            }
            for (File file : files) {
                ZipUtils._putFileEntry(file, prefix + file.getName(), zout);
            }
        }
        finally {
            if (zout != null) {
                zout.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String prefix, InputStream zipStream, File dir) throws IOException {
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new BufferedInputStream(zipStream));
            ZipUtils.unzip(prefix, in, dir);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream zipStream, File dir) throws IOException {
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new BufferedInputStream(zipStream));
            ZipUtils.unzip(in, dir);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String prefix, URL zip, File dir) throws IOException {
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new BufferedInputStream(zip.openStream()));
            ZipUtils.unzip(prefix, in, dir);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(URL zip, File dir) throws IOException {
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new BufferedInputStream(zip.openStream()));
            ZipUtils.unzip(in, dir);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String prefix, File zip, File dir) throws IOException {
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
            ZipUtils.unzip(prefix, in, dir);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zip, File dir) throws IOException {
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
            ZipUtils.unzip(in, dir);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void unzip(String prefix, ZipInputStream in, File dir) throws IOException {
        dir.mkdirs();
        ZipEntry entry = in.getNextEntry();
        while (entry != null) {
            if (!entry.getName().startsWith(prefix)) {
                entry = in.getNextEntry();
                continue;
            }
            File file = new File(dir, entry.getName().substring(prefix.length()));
            if (entry.isDirectory()) {
                file.mkdirs();
            } else {
                file.getParentFile().mkdirs();
                FileUtils.copyToFile(in, file);
            }
            entry = in.getNextEntry();
        }
    }

    public static void unzip(ZipInputStream in, File dir) throws IOException {
        dir.mkdirs();
        ZipEntry entry = in.getNextEntry();
        while (entry != null) {
            File file = new File(dir, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
            } else {
                file.getParentFile().mkdirs();
                FileUtils.copyToFile(in, file);
            }
            entry = in.getNextEntry();
        }
    }

    public static void unzipIgnoreDirs(ZipInputStream in, File dir) throws IOException {
        dir.mkdirs();
        ZipEntry entry = in.getNextEntry();
        while (entry != null) {
            String entryName = entry.getName();
            if (!entry.isDirectory()) {
                int p = entryName.lastIndexOf(47);
                if (p > -1) {
                    entryName = entryName.substring(p + 1);
                }
                File file = new File(dir, entryName);
                FileUtils.copyToFile(in, file);
            }
            entry = in.getNextEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipIgnoreDirs(InputStream zipStream, File dir) throws IOException {
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new BufferedInputStream(zipStream));
            ZipUtils.unzipIgnoreDirs(in, dir);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zip, File dir, PathFilter filter) throws IOException {
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
            ZipUtils.unzip(in, dir, filter);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void unzip(ZipInputStream in, File dir, PathFilter filter) throws IOException {
        if (filter == null) {
            ZipUtils.unzip(in, dir);
            return;
        }
        ZipEntry entry = in.getNextEntry();
        while (entry != null) {
            String entryName = entry.getName();
            if (filter.accept(new Path(entryName))) {
                File file = new File(dir, entryName);
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    file.getParentFile().mkdirs();
                    FileUtils.copyToFile(in, file);
                }
            }
            entry = in.getNextEntry();
        }
    }

    public static InputStream getEntryContentAsStream(File file, String entryName) throws IOException {
        InputStream result = null;
        ZipFile zip = new ZipFile(file);
        ZipEntry entry = zip.getEntry(entryName);
        if (entry != null) {
            result = zip.getInputStream(entry);
        }
        return result;
    }

    public static String getEntryContentAsString(File file, String entryName) throws IOException {
        InputStream resultStream = ZipUtils.getEntryContentAsStream(file, entryName);
        return FileUtils.read(resultStream);
    }

    public static byte[] getEntryContentAsBytes(File file, String entryName) throws IOException {
        InputStream resultStream = ZipUtils.getEntryContentAsStream(file, entryName);
        return FileUtils.readBytes(resultStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getEntryNames(File file) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        ZipFile zip = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                result.add(entry.getName());
            }
        }
        finally {
            zip.close();
        }
        return result;
    }

    public static boolean hasEntry(File file, String entryName) throws IOException {
        List<String> elements = ZipUtils.getEntryNames(file);
        return elements.contains(entryName);
    }

    public static InputStream getEntryContentAsStream(InputStream stream, String entryName) throws IOException {
        ZipInputStream zip = new ZipInputStream(stream);
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            if (entry.getName().equals(entryName)) {
                return zip;
            }
            entry = zip.getNextEntry();
        }
        return null;
    }

    public static String getEntryContentAsString(InputStream stream, String searchedEntryName) throws IOException {
        InputStream resultStream = ZipUtils.getEntryContentAsStream(stream, searchedEntryName);
        return FileUtils.read(resultStream);
    }

    public static byte[] getEntryContentAsBytes(InputStream stream, String searchedEntryName) throws IOException {
        InputStream resultStream = ZipUtils.getEntryContentAsStream(stream, searchedEntryName);
        return FileUtils.readBytes(resultStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getEntryNames(InputStream stream) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        ZipInputStream zip = new ZipInputStream(stream);
        try {
            while (zip.available() == 1) {
                ZipEntry entry = zip.getNextEntry();
                if (entry == null) continue;
                result.add(entry.getName());
            }
        }
        finally {
            zip.close();
        }
        return result;
    }

    public static boolean hasEntry(InputStream stream, String entryName) throws IOException {
        List<String> elements = ZipUtils.getEntryNames(stream);
        return elements.contains(entryName);
    }

    public static InputStream getEntryContentAsStream(URL url, String entryName) throws IOException {
        return ZipUtils.getEntryContentAsStream(url.openStream(), entryName);
    }

    public static String getEntryContentAsString(URL url, String entryName) throws IOException {
        InputStream resultStream = ZipUtils.getEntryContentAsStream(url, entryName);
        return FileUtils.read(resultStream);
    }

    public static byte[] getEntryContentAsBytes(URL url, String entryName) throws IOException {
        InputStream resultStream = ZipUtils.getEntryContentAsStream(url, entryName);
        return FileUtils.readBytes(resultStream);
    }

    public static List<String> getEntryNames(URL url) throws IOException {
        return ZipUtils.getEntryNames(url.openStream());
    }

    public static boolean hasEntry(URL url, String entryName) throws IOException {
        return ZipUtils.hasEntry(url.openStream(), entryName);
    }
}

