/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.core.api.repository.RepositoryInstanceHandler;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.client.ConnectionListener;
import org.nuxeo.ecm.core.client.DefaultLoginHandler;
import org.nuxeo.ecm.core.client.LoginHandler;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.SchemaManagerImpl;
import org.nuxeo.ecm.core.schema.TypeProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceManager;
import org.nuxeo.runtime.api.login.LoginService;
import org.nuxeo.runtime.api.login.SecurityDomain;
import org.nuxeo.runtime.config.AutoConfigurationService;
import org.nuxeo.runtime.remoting.RemotingService;
import org.nuxeo.runtime.services.streaming.StreamingService;

public final class NuxeoClient {
    private LoginHandler loginHandler;
    private final List<RepositoryInstance> repositoryInstances;
    private final ListenerList connectionListeners = new ListenerList();
    private InvokerLocator locator;
    private String serverName;
    private final AutoConfigurationService cfg = new AutoConfigurationService();
    private RepositoryManager repositoryMgr;
    private boolean multiThreadedLogin = false;
    private static final NuxeoClient instance = new NuxeoClient();
    private static final Log log = LogFactory.getLog(NuxeoClient.class);

    private NuxeoClient() {
        this.loginHandler = this.loginHandler == null ? new DefaultLoginHandler() : this.loginHandler;
        this.repositoryInstances = new Vector<RepositoryInstance>();
    }

    public static NuxeoClient getInstance() {
        return instance;
    }

    public void setMultiThreadedLogin(boolean useMultiThreadedLogin) {
        this.multiThreadedLogin = useMultiThreadedLogin;
    }

    public boolean getMultiThreadedLogin() {
        return this.multiThreadedLogin;
    }

    public synchronized void connect(String locator) throws Exception {
        if (this.locator != null) {
            throw new IllegalStateException("Client is already connected");
        }
        this.doConnect(AutoConfigurationService.createLocator((String)locator));
    }

    public synchronized void connect(InvokerLocator locator) throws Exception {
        if (this.locator != null) {
            throw new IllegalStateException("Client is already connected");
        }
        this.doConnect(locator);
    }

    public synchronized void connect(String host, int port) throws Exception {
        if (this.locator != null) {
            throw new IllegalStateException("Client is already connected");
        }
        this.doConnect(AutoConfigurationService.createLocator((String)host, (int)port));
    }

    public synchronized void forceConnect(InvokerLocator locator) throws Exception {
        if (this.locator != null) {
            this.disconnect();
        }
        this.doConnect(locator);
    }

    public synchronized void forceConnect(String locator) throws Exception {
        if (this.locator != null) {
            this.disconnect();
        }
        this.doConnect(AutoConfigurationService.createLocator((String)locator));
    }

    public synchronized void forceConnect(String host, int port) throws Exception {
        if (this.locator != null) {
            this.disconnect();
        }
        this.doConnect(AutoConfigurationService.createLocator((String)host, (int)port));
    }

    public synchronized void tryConnect(String host, int port) throws Exception {
        if (this.locator != null) {
            return;
        }
        this.doConnect(AutoConfigurationService.createLocator((String)host, (int)port));
    }

    public synchronized void tryConnect(String url) throws Exception {
        if (this.locator != null) {
            return;
        }
        this.doConnect(AutoConfigurationService.createLocator((String)url));
    }

    public synchronized void tryConnect(InvokerLocator locator) throws Exception {
        if (this.locator != null) {
            return;
        }
        this.doConnect(locator);
    }

    private void doConnect(InvokerLocator locator) throws Exception {
        this.locator = locator;
        try {
            StreamingService streamingService;
            String oldLocator;
            int p;
            this.cfg.load(locator);
            String newPort = Framework.getProperty((String)"org.nuxeo.runtime.1.3.3.streaming.port");
            if (newPort != null && (p = (oldLocator = (streamingService = (StreamingService)Framework.getRuntime().getComponent(StreamingService.NAME)).getServerLocator()).lastIndexOf(58)) > -1) {
                String withoutPort = oldLocator.substring(0, p);
                String serverLocator = withoutPort + ":" + newPort;
                streamingService.stopManager();
                streamingService.setServerLocator(serverLocator);
                streamingService.setServer(false);
                streamingService.startManager();
            }
            NuxeoClient.schemaRemotingWorkaround(locator.getHost());
            if (!this.multiThreadedLogin) {
                LoginService ls = (LoginService)Framework.getService(LoginService.class);
                SecurityDomain sysDomain = ls.getSecurityDomain("nuxeo-system-login");
                SecurityDomain clientDomain = ls.getSecurityDomain("nuxeo-client-login");
                NuxeoClient.adaptClientSecurityDomain(sysDomain);
                NuxeoClient.adaptClientSecurityDomain(clientDomain);
            }
            this.login();
        }
        catch (Exception e) {
            this.locator = null;
            throw e;
        }
        this.fireConnected(this);
    }

    public static void adaptClientSecurityDomain(SecurityDomain sd) {
        AppConfigurationEntry[] entries = sd.getAppConfigurationEntries();
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                AppConfigurationEntry entry = entries[i];
                if (!"org.jboss.security.ClientLoginModule".equals(entry.getLoginModuleName())) continue;
                Map<String, ?> opts = entry.getOptions();
                HashMap newOpts = new HashMap(opts);
                newOpts.put("multi-threaded", "false");
                entries[i] = new AppConfigurationEntry(entry.getLoginModuleName(), entry.getControlFlag(), entry.getOptions());
            }
        }
    }

    private static void schemaRemotingWorkaround(String host) throws Exception {
        ServiceManager serviceManager = (ServiceManager)Framework.getLocalService(ServiceManager.class);
        ServiceDescriptor sd = new ServiceDescriptor(TypeProvider.class, "core");
        sd.setLocator("%TypeProviderBean");
        serviceManager.registerService(sd);
        TypeProvider typeProvider = (TypeProvider)Framework.getService(TypeProvider.class);
        SchemaManager schemaMgr = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        ((SchemaManagerImpl)schemaMgr).importTypes(typeProvider);
    }

    public synchronized void disconnect() throws Exception {
        if (this.locator == null) {
            throw new IllegalStateException("Client is not connected");
        }
        this.doDisconnect();
    }

    public synchronized void tryDisconnect() throws Exception {
        if (this.locator == null) {
            return;
        }
        this.doDisconnect();
    }

    private void doDisconnect() throws Exception {
        this.locator = null;
        this.serverName = null;
        Iterator<RepositoryInstance> it = this.repositoryInstances.iterator();
        while (it.hasNext()) {
            RepositoryInstance repo = it.next();
            try {
                repo.close();
            }
            catch (Exception e) {
                log.debug((Object)("Error while trying to close " + repo), (Throwable)e);
            }
            it.remove();
        }
        this.logout();
        this.repositoryMgr = null;
        this.fireDisconnected(this);
    }

    public synchronized void reconnect() throws Exception {
        if (this.locator == null) {
            throw new IllegalStateException("Client is not connected");
        }
        InvokerLocator locator = this.locator;
        this.disconnect();
        this.connect(locator);
    }

    public AutoConfigurationService getConfigurationService() {
        return this.cfg;
    }

    public synchronized String getServerName() {
        if (this.locator == null) {
            throw new IllegalStateException("Client is not connected");
        }
        if (this.serverName == null) {
            this.serverName = this.cfg == null ? RemotingService.ping((String)this.locator.getHost(), (int)this.locator.getPort()) : this.cfg.getServerConfiguration().getProductInfo();
        }
        return this.serverName;
    }

    public synchronized boolean isConnected() {
        return this.locator != null;
    }

    public String getServerHost() {
        if (this.locator == null) {
            throw new IllegalStateException("Client is not connected");
        }
        return this.locator.getHost();
    }

    public int getServerPort() {
        if (this.locator == null) {
            throw new IllegalStateException("Client is not connected");
        }
        return this.locator.getPort();
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public synchronized LoginHandler getLoginHandler() {
        return this.loginHandler;
    }

    public synchronized void setLoginHandler(LoginHandler loginHandler) {
        this.loginHandler = loginHandler;
    }

    public synchronized void login() throws LoginException {
        this.loginHandler.login();
    }

    public synchronized void logout() throws LoginException {
        this.loginHandler.logout();
    }

    public RepositoryManager getRepositoryManager() throws Exception {
        if (this.repositoryMgr == null) {
            this.repositoryMgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
        }
        return this.repositoryMgr;
    }

    public Repository[] getRepositories() throws Exception {
        Collection repos = this.getRepositoryManager().getRepositories();
        return repos.toArray(new Repository[repos.size()]);
    }

    public Repository getDefaultRepository() throws Exception {
        return this.getRepositoryManager().getDefaultRepository();
    }

    public Repository getRepository(String name) throws Exception {
        return this.getRepositoryManager().getRepository(name);
    }

    public RepositoryInstance openRepository() throws Exception {
        Repository repository = this.getRepositoryManager().getDefaultRepository();
        RepositoryInstance repo = NuxeoClient.newRepositoryInstance(repository);
        this.repositoryInstances.add(repo);
        return repo;
    }

    public RepositoryInstance openRepository(String name) throws Exception {
        Repository repository = this.getRepositoryManager().getRepository(name);
        RepositoryInstance repo = NuxeoClient.newRepositoryInstance(repository);
        this.repositoryInstances.add(repo);
        return repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRepository(RepositoryInstance repo) throws Exception {
        try {
            repo.close();
        }
        finally {
            this.repositoryInstances.remove(repo);
        }
    }

    public RepositoryInstance[] getRepositoryInstances() {
        return this.repositoryInstances.toArray(new RepositoryInstance[this.repositoryInstances.size()]);
    }

    public static RepositoryInstance newRepositoryInstance(Repository repository) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = NuxeoClient.class.getClassLoader();
        }
        return new RepositoryInstanceHandler(repository).getProxy();
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add((Object)listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove((Object)listener);
    }

    private void fireDisconnected(NuxeoClient client) {
        Object[] listeners;
        for (Object listener : listeners = this.connectionListeners.getListeners()) {
            ((ConnectionListener)listener).disconnected(client);
        }
    }

    private void fireConnected(NuxeoClient client) {
        Object[] listeners;
        for (Object listener : listeners = this.connectionListeners.getListeners()) {
            ((ConnectionListener)listener).connected(client);
        }
    }
}

