/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.binding;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.runtime.ComponentEvent;
import org.nuxeo.runtime.ComponentListener;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.binding.AbstractServiceProvider;
import org.nuxeo.runtime.binding.Binding;
import org.nuxeo.runtime.binding.RuntimeServiceBinding;
import org.nuxeo.runtime.binding.StaticBinding;
import org.nuxeo.runtime.model.ComponentInstance;

public class RuntimeServiceProvider
extends AbstractServiceProvider
implements ComponentListener {
    protected RuntimeService runtime = Framework.getRuntime();
    protected Map<String, Binding> bindings;

    public RuntimeServiceProvider() {
        this.runtime.getComponentManager().addComponentListener(this);
        this.bindings = new ConcurrentHashMap<String, Binding>();
    }

    @Override
    public void destroy() {
        this.runtime.getComponentManager().removeComponentListener(this);
        this.runtime = null;
        this.bindings = null;
    }

    @Override
    public Object getService(Class<?> serviceClass, String bindingKey) {
        ComponentInstance comp = this.runtime.getComponentManager().getComponentProvidingService(serviceClass);
        if (comp == null) {
            return null;
        }
        Object obj = comp.getAdapter(serviceClass);
        if (obj != null && this.manager != null) {
            Object obj2 = comp.getAdapter(serviceClass);
            if (obj == obj2) {
                StaticBinding binding = new StaticBinding(bindingKey, obj);
                this.manager.registerBinding(bindingKey, binding);
                this.bindings.put(serviceClass.getName(), binding);
            } else {
                RuntimeServiceBinding binding = new RuntimeServiceBinding(bindingKey, comp, serviceClass);
                this.manager.registerBinding(bindingKey, binding);
                this.bindings.put(serviceClass.getName(), binding);
            }
            return obj;
        }
        return null;
    }

    @Override
    public void handleEvent(ComponentEvent event) {
        String[] services;
        if (this.manager != null && event.id == 5 && (services = event.registrationInfo.getProvidedServiceNames()) != null) {
            for (String service : services) {
                Binding binding = this.bindings.remove(service);
                if (binding == null) continue;
                this.manager.unregisterBinding(binding.getKey());
            }
        }
    }
}

