/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.persistence.fs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.runtime.model.persistence.Contribution;
import org.nuxeo.runtime.model.persistence.ContributionStorage;
import org.nuxeo.runtime.model.persistence.fs.ContributionFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FileSystemStorage
implements ContributionStorage {
    public static Log log = LogFactory.getLog(FileSystemStorage.class);
    protected File root = new File(Environment.getDefault().getData(), "contribs");
    protected static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public FileSystemStorage() {
        this.root.mkdirs();
    }

    public static synchronized String safeRead(File file) throws IOException {
        return FileUtils.readFile((File)file);
    }

    public static synchronized void safeWrite(File file, String content) throws IOException {
        FileUtils.writeFile((File)file, (String)content);
    }

    public static synchronized boolean safeCreate(File file, String content) throws IOException {
        if (file.isFile()) {
            return false;
        }
        FileUtils.writeFile((File)file, (String)content);
        return true;
    }

    public static synchronized boolean safeRemove(File file) throws IOException {
        return file.delete();
    }

    public static void loadMetadata(ContributionFile contrib) {
        try {
            Node node;
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(contrib.getContent().getBytes()));
            Element root = doc.getDocumentElement();
            contrib.disabled = Boolean.parseBoolean(root.getAttribute("disabled"));
            for (node = root.getFirstChild(); !(node == null || node.getNodeType() == 1 && "documentation".equals(node.getNodeName())); node = node.getNextSibling()) {
            }
            if (node != null) {
                StringBuilder buf = new StringBuilder();
                for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 3) continue;
                    buf.append(node.getNodeValue());
                }
                contrib.setDescription(buf.toString().trim());
            } else {
                contrib.setDescription("");
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to rread contribution metadata", (Throwable)e);
        }
    }

    @Override
    public Contribution addContribution(Contribution contribution) throws Exception {
        String content;
        File file = new File(this.root, contribution.getName() + ".xml");
        if (FileSystemStorage.safeCreate(file, content = contribution.getContent())) {
            return new ContributionFile(contribution.getName(), file);
        }
        return null;
    }

    @Override
    public Contribution getContribution(String name) {
        File file = new File(this.root, name + ".xml");
        if (file.isFile()) {
            return new ContributionFile(name, file);
        }
        return null;
    }

    @Override
    public List<Contribution> getContributions() {
        ArrayList<Contribution> result = new ArrayList<Contribution>();
        File[] files = this.root.listFiles();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            String name = file.getName();
            if (!name.endsWith(".xml")) continue;
            name = name.substring(0, name.length() - 4);
            result.add(new ContributionFile(name, file));
        }
        return result;
    }

    @Override
    public boolean removeContribution(Contribution contrib) throws Exception {
        return FileSystemStorage.safeRemove(new File(this.root, contrib.getName() + ".xml"));
    }

    @Override
    public Contribution updateContribution(Contribution contribution) throws Exception {
        Node node;
        File file = new File(this.root, contribution.getName() + ".xml");
        String content = FileSystemStorage.safeRead(file);
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document doc = docBuilder.parse(new ByteArrayInputStream(content.getBytes()));
        Element root = doc.getDocumentElement();
        if (contribution.isDisabled()) {
            root.setAttribute("disabled", "true");
        } else {
            root.removeAttribute("disabled");
        }
        for (node = root.getFirstChild(); !(node == null || node.getNodeType() == 1 && "documentation".equals(node.getNodeName())); node = node.getNextSibling()) {
        }
        String description = contribution.getDescription();
        if (description == null) {
            description = "";
        }
        if (node != null) {
            root.removeChild(node);
        }
        Element el = doc.createElement("documentation");
        el.appendChild(doc.createTextNode(contribution.getDescription()));
        root.appendChild(el);
        FileSystemStorage.safeWrite(file, DOMSerializer.toString((Document)doc));
        return this.getContribution(contribution.getName());
    }
}

