/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.streaming;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.runtime.remoting.transporter.TransporterServer;
import org.nuxeo.runtime.services.streaming.DownloadInfo;
import org.nuxeo.runtime.services.streaming.StreamManager;
import org.nuxeo.runtime.services.streaming.StreamSource;
import org.nuxeo.runtime.services.streaming.StreamingServer;
import org.nuxeo.runtime.services.streaming.UploadedStreamSource;

public class StreamManagerServer
implements StreamingServer,
StreamManager {
    private static long uploadCount = 0L;
    private static long downloadCount = 0L;
    protected final Map<String, StreamSource> streams = new Hashtable<String, StreamSource>();
    protected final Map<String, UploadSession> uploads = new HashMap<String, UploadSession>();
    protected final Map<Long, DownloadSession> downloads = new HashMap<Long, DownloadSession>();
    protected final String locatorURI;
    protected final File tmpDir;
    protected final TransporterServer transporterServer;

    public StreamManagerServer(String host, int port, File tmpDir) throws Exception {
        this(new InvokerLocator("socket", host, port, null, null), tmpDir);
    }

    public StreamManagerServer(String serverLocator, File tmpDir) throws Exception {
        this(new InvokerLocator(serverLocator), tmpDir);
    }

    public StreamManagerServer(InvokerLocator locator, File tmpDir) throws Exception {
        this.tmpDir = tmpDir;
        tmpDir.mkdirs();
        this.locatorURI = locator.getLocatorURI();
        this.transporterServer = TransporterServer.createTransporterServer(locator, (Object)this, StreamingServer.class.getName());
    }

    public StreamManagerServer(TransporterServer transporterServer, File tmpDir) throws Exception {
        this.tmpDir = tmpDir;
        tmpDir.mkdirs();
        this.locatorURI = transporterServer.getLocatorURI();
        this.transporterServer = null;
        transporterServer.addHandler(this, StreamingServer.class.getName());
    }

    @Override
    public void start() throws Exception {
        if (this.transporterServer != null) {
            this.transporterServer.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.transporterServer != null) {
            this.transporterServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addStream(StreamSource src) throws IOException {
        long up;
        Map<String, UploadSession> map = this.uploads;
        synchronized (map) {
            up = StreamManagerServer.incrementUploads();
        }
        String uri = this.locatorURI + "/stream#" + up;
        this.addResource(uri, src);
        return uri;
    }

    public void addResource(String uri, StreamSource src) {
        this.streams.put(uri, src);
    }

    @Override
    public StreamSource getStream(String uri) {
        return this.streams.get(uri);
    }

    @Override
    public boolean hasStream(String uri) {
        return this.streams.containsKey(uri);
    }

    @Override
    public void removeStream(String uri) {
        StreamSource src = this.streams.remove(uri);
        if (src != null) {
            src.destroy();
        }
    }

    private static long incrementUploads() {
        uploadCount = uploadCount == Long.MAX_VALUE ? 0L : uploadCount + 1L;
        return uploadCount;
    }

    private static long incrementDownloads() {
        downloadCount = downloadCount == Long.MAX_VALUE ? 0L : downloadCount + 1L;
        return downloadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getNextFileName() {
        String fileName;
        Map<String, UploadSession> map = this.uploads;
        synchronized (map) {
            fileName = "uploaded_resource#" + uploadCount;
            uploadCount = uploadCount == Long.MAX_VALUE ? 0L : ++uploadCount;
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadInfo createDownloadSession(String uri) throws IOException {
        DownloadSession ds;
        StreamSource src = this.streams.get(uri);
        if (src == null) {
            throw new NoSuchElementException("Not resource with uri " + uri);
        }
        Map<Long, DownloadSession> map = this.downloads;
        synchronized (map) {
            ds = new DownloadSession(src);
            this.downloads.put(ds.id, ds);
        }
        return new DownloadInfo(ds.id, ds.in.available());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] downloadBytes(long sid, int size) throws IOException {
        DownloadSession ds;
        Map<Long, DownloadSession> map = this.downloads;
        synchronized (map) {
            ds = this.downloads.get(sid);
        }
        if (ds == null) {
            throw new IllegalArgumentException("No such download session: " + sid);
        }
        byte[] bytes = new byte[size];
        int length = ds.in.read(bytes, 0, size);
        if (length > -1) {
            ds.downloaded += length;
            if (length < bytes.length) {
                byte[] tmp = new byte[length];
                System.arraycopy(bytes, 0, tmp, 0, length);
                bytes = tmp;
            }
            return bytes;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeDownloadSession(long sid) throws IOException {
        DownloadSession ds;
        Map<Long, DownloadSession> map = this.downloads;
        synchronized (map) {
            ds = this.downloads.remove(sid);
        }
        if (ds == null) {
            throw new IllegalArgumentException("No such download session: " + sid);
        }
        ds.src = null;
        ds.in.close();
        ds.in = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createUploadSession() throws IOException {
        Map<String, UploadSession> map = this.uploads;
        synchronized (map) {
            UploadSession us = new UploadSession();
            this.uploads.put(us.uri, us);
            return us.uri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadBytes(String uri, byte[] bytes) throws IOException {
        UploadSession us;
        Map<String, UploadSession> map = this.uploads;
        synchronized (map) {
            us = this.uploads.get(uri);
        }
        if (us == null) {
            throw new IllegalArgumentException("No such upload session " + uri);
        }
        if (bytes == null) {
            this.doCloseUpload(us);
        } else {
            us.out.write(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeUploadSession(String uri) throws IOException {
        UploadSession us;
        Map<String, UploadSession> map = this.uploads;
        synchronized (map) {
            us = this.uploads.remove(uri);
        }
        if (us == null) {
            throw new IllegalArgumentException("No such upload session: " + uri);
        }
        this.doCloseUpload(us);
    }

    protected void doCloseUpload(UploadSession us) throws IOException {
        us.out.close();
        this.addResource(us.uri, new UploadedStreamSource(us.file));
        us.file = null;
        us.uri = null;
    }

    public static void main(String[] args) {
        try {
            StreamManagerServer server = new StreamManagerServer("localhost", 3234, new File("/tmp/uploads"));
            server.start();
            while (true) {
                Thread.sleep(1000000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    static /* synthetic */ long access$100() {
        return StreamManagerServer.incrementDownloads();
    }

    public class DownloadSession {
        public final long id = StreamManagerServer.access$100();
        public int downloaded;
        public StreamSource src;
        public InputStream in;

        public DownloadSession(StreamSource src) throws IOException {
            this.src = src;
            this.in = src.getStream();
            this.downloaded = 0;
        }
    }

    public class UploadSession {
        public String uri;
        public int uploaded;
        public File file;
        public FileOutputStream out;

        public UploadSession() throws IOException {
            String name = String.valueOf(StreamManagerServer.incrementUploads());
            this.uri = StreamManagerServer.this.locatorURI + "/stream#" + name;
            this.file = new File(StreamManagerServer.this.tmpDir, name);
            this.out = new FileOutputStream(this.file);
            this.uploaded = 0;
        }
    }
}

