/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Comparator;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassToStringAction;
import org.jboss.mx.loading.RepositoryClassLoader;

public class ClassLoadingTask {
    protected static Logger log = Logger.getLogger(ClassLoadingTask.class);
    protected static Comparator taskComparator = new ThreadTaskComparator();
    public static final int FOUND_CLASS_LOADER = 1;
    public static final int NEXT_EVENT = 2;
    public static final int WAIT_ON_EVENT = 3;
    public static final int FINISHED = 4;
    protected String classname;
    protected Thread requestingThread;
    protected RepositoryClassLoader requestingClassLoader;
    protected Class loadedClass;
    protected int loadOrder = Integer.MAX_VALUE;
    protected int stopOrder = Integer.MAX_VALUE;
    protected Throwable loadException;
    protected int threadTaskCount;
    protected int state;
    protected boolean trace;
    protected int numCCE;

    protected ClassLoadingTask(String classname, RepositoryClassLoader requestingClassLoader, Thread requestingThread) {
        this(classname, requestingClassLoader, requestingThread, Integer.MAX_VALUE);
    }

    protected ClassLoadingTask(String classname, RepositoryClassLoader requestingClassLoader, Thread requestingThread, int stopAt) {
        this.requestingThread = requestingThread;
        this.requestingClassLoader = requestingClassLoader;
        this.classname = classname;
        this.stopOrder = stopAt;
        this.trace = log.isTraceEnabled();
    }

    synchronized int incNumCCE() {
        int cce = this.numCCE++;
        return cce;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append('{');
        buffer.append("classname: " + this.classname);
        buffer.append(", requestingThread: " + this.requestingThread);
        buffer.append(", requestingClassLoader: " + this.requestingClassLoader);
        buffer.append(", loadedClass: " + this.loadedClass);
        ClassToStringAction.toString(this.loadedClass, buffer);
        buffer.append(", loadOrder: " + this.loadOrder);
        buffer.append(", loadException: " + this.loadException);
        buffer.append(", threadTaskCount: " + this.threadTaskCount);
        buffer.append(", state: " + this.state);
        buffer.append(", #CCE: " + this.numCCE);
        buffer.append('}');
        if (this.trace && this.loadException != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.loadException.printStackTrace(pw);
            buffer.append("loadException details:\n");
            buffer.append(sw.toString());
        }
        return buffer.toString();
    }

    ThreadTask newThreadTask(RepositoryClassLoader ucl, Thread t, int order, boolean reschedule, boolean releaseInNextTask) {
        if (!reschedule) {
            ++this.threadTaskCount;
        }
        return new ThreadTask(ucl, t, order, releaseInNextTask);
    }

    synchronized void setLoadError(Throwable t) {
        --this.threadTaskCount;
        if (this.trace) {
            log.trace("setLoadedError, error=" + t);
        }
        this.loadException = t;
    }

    private synchronized void setLoadedClass(Class theClass, int order) {
        --this.threadTaskCount;
        if (this.trace) {
            log.trace("setLoadedClass, theClass=" + theClass + ", order=" + order);
        }
        if (this.loadedClass != null && order == this.loadOrder && theClass != null) {
            StringBuffer tmp = new StringBuffer("Duplicate class found: " + this.classname);
            tmp.append('\n');
            ProtectionDomain pd = this.loadedClass.getProtectionDomain();
            CodeSource cs = pd != null ? pd.getCodeSource() : null;
            tmp.append("Current CS: " + cs);
            tmp.append('\n');
            pd = theClass.getProtectionDomain();
            cs = pd != null ? pd.getCodeSource() : null;
            tmp.append("Duplicate CS: " + cs);
            log.warn(tmp.toString());
        }
        if (theClass != null) {
            if (this.loadedClass == null || order <= this.loadOrder) {
                this.loadedClass = theClass;
                this.loadOrder = order;
            } else {
                ProtectionDomain pd = this.loadedClass.getProtectionDomain();
                CodeSource cs = pd != null ? pd.getCodeSource() : null;
                ProtectionDomain pd2 = theClass.getProtectionDomain();
                CodeSource cs2 = pd != null ? pd2.getCodeSource() : null;
                log.debug("Ignoring source of: " + this.classname + " from CodeSource: " + cs2 + ", due to order(" + order + ">=" + this.loadOrder + "), " + "accepted CodeSource: " + cs);
            }
        }
    }

    class ThreadTask {
        RepositoryClassLoader ucl;
        Thread t;
        int order;
        boolean releaseInNextTask;

        ThreadTask(RepositoryClassLoader ucl, Thread t, int order, boolean releaseInNextTask) {
            this.ucl = ucl;
            this.t = t;
            this.order = order;
            this.releaseInNextTask = releaseInNextTask;
        }

        public String toString() {
            return "{t=" + this.t + ", ucl=" + this.ucl + ", name=" + ClassLoadingTask.this.classname + ", requestingThread=" + ClassLoadingTask.this.requestingThread + ", order=" + this.order + ", releaseInNextTask=" + this.releaseInNextTask + "}";
        }

        String getClassname() {
            return ClassLoadingTask.this.classname;
        }

        Class getLoadedClass() {
            return ClassLoadingTask.this.loadedClass;
        }

        ClassLoadingTask getLoadTask() {
            return ClassLoadingTask.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run() throws ClassNotFoundException {
            Class theClass = null;
            try {
                if (ClassLoadingTask.this.loadedClass == null) {
                    theClass = this.ucl.loadClassLocally(ClassLoadingTask.this.classname, false);
                    ClassLoadingTask.this.setLoadedClass(theClass, this.order);
                } else if (ClassLoadingTask.this.trace) {
                    log.trace("Already found class(" + ClassLoadingTask.this.loadedClass + "), skipping loadClassLocally");
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    static class ThreadTaskComparator
    implements Comparator {
        ThreadTaskComparator() {
        }

        public int compare(Object o1, Object o2) {
            ThreadTask t1 = (ThreadTask)o1;
            ThreadTask t2 = (ThreadTask)o2;
            int compare = t1.order - t2.order;
            if (compare == 0) {
                compare = t1.ucl.getAddedOrder() - t2.ucl.getAddedOrder();
            }
            return compare;
        }
    }
}

