/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.login;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

public class SystemPrincipal
implements NuxeoPrincipal {
    private static final long serialVersionUID = -3381784063138281706L;
    private static final char[] SYS_PASSWORD = null;
    private static final List<String> SYS_GROUPS = Collections.unmodifiableList(Arrays.asList("administrators"));
    private static final List<String> SYS_ROLES = Collections.unmodifiableList(new ArrayList());
    private String origUserName;
    private int hash;

    public SystemPrincipal(String origUserName) {
        this.origUserName = origUserName == null ? "system" : origUserName;
        this.computeHash();
    }

    private void computeHash() {
        this.hash = this.origUserName != null ? ("system-" + this.origUserName).hashCode() : "system".hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof SystemPrincipal) {
            if (!"system".equals(((Principal)other).getName())) {
                return false;
            }
            if (this.origUserName == null) {
                return ((SystemPrincipal)other).origUserName == null;
            }
            return this.origUserName.equals(((SystemPrincipal)other).origUserName);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String getCompany() {
        return "Nuxeo";
    }

    public String getFirstName() {
        return "System";
    }

    public String getLastName() {
        return "System";
    }

    public String getName() {
        return "system";
    }

    public List<String> getGroups() {
        return SYS_GROUPS;
    }

    public List<String> getAllGroups() {
        return SYS_GROUPS;
    }

    public List<String> getRoles() {
        return SYS_ROLES;
    }

    public String getPassword() {
        if (SYS_PASSWORD == null) {
            return null;
        }
        return new String(SYS_PASSWORD);
    }

    public String getPrincipalId() {
        return "";
    }

    public String getOriginatingUser() {
        return this.origUserName;
    }

    public void setOriginatingUser(String originatingUser) {
        this.origUserName = originatingUser;
        this.computeHash();
    }

    public DocumentModel getModel() {
        return null;
    }

    public void setCompany(String company) {
    }

    public void setFirstName(String firstName) {
    }

    public void setLastName(String lastName) {
    }

    public void setName(String userName) {
    }

    public void setGroups(List<String> groups) {
    }

    public void setRoles(List<String> roles) {
    }

    public void setPassword(String password) {
    }

    public void setPrincipalId(String principalId) {
    }

    public void setModel(DocumentModel model) {
    }

    public boolean isMemberOf(String group) {
        return SYS_GROUPS.contains(group);
    }

    public String toString() {
        return this.getName();
    }

    public boolean isAdministrator() {
        return true;
    }

    public boolean isAnonymous() {
        return false;
    }
}

