/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.api.RepositoryDescriptor;
import org.nuxeo.ecm.platform.api.Server;
import org.nuxeo.ecm.platform.api.ServerDescriptor;
import org.nuxeo.ecm.platform.api.ServiceDescriptor;
import org.nuxeo.runtime.api.Framework;

@Deprecated
public final class Platform
implements Serializable {
    private static final long serialVersionUID = 6176553194123324439L;
    private final String name;
    private Map<String, ServiceDescriptor> services;
    private Map<String, RepositoryDescriptor> repositories;
    private Map<String, Server> servers;
    private final Map<String, List<ServerDescriptor>> pendingBindings;

    public Platform(String name) {
        this.name = name;
        this.servers = new HashMap<String, Server>();
        this.services = new HashMap<String, ServiceDescriptor>();
        this.repositories = new HashMap<String, RepositoryDescriptor>();
        this.pendingBindings = new HashMap<String, List<ServerDescriptor>>();
    }

    public synchronized void addServer(ServerDescriptor sd) throws Exception {
        Server server = this.servers.get(sd.name);
        if (server != null) {
            if (sd.services != null) {
                server.registerServices(sd.services.values());
            }
            if (sd.repositories != null) {
                server.registerRepositories(sd.repositories.values());
            }
        } else if (sd.host != null) {
            server = new Server(this, sd);
            this.servers.put(sd.name, server);
            this.registerPendingBindings(server);
        } else {
            this.addToPendingQueue(sd);
        }
    }

    public synchronized void removeServer(String name) {
        Server server = this.servers.remove(name);
        if (server == null) {
            return;
        }
        Iterator<ServiceDescriptor> sit = this.services.values().iterator();
        while (sit.hasNext()) {
            ServiceDescriptor sd = sit.next();
            if (sd.server != server) continue;
            sit.remove();
        }
        Iterator<RepositoryDescriptor> rit = this.repositories.values().iterator();
        while (rit.hasNext()) {
            RepositoryDescriptor sd = rit.next();
            if (sd.server != server) continue;
            rit.remove();
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized <T> T getService(Class<T> remoteItf) throws Exception {
        ServiceDescriptor sd = this.services.get(remoteItf.getName());
        if (sd != null) {
            return (T)sd.server.getService(sd);
        }
        return (T)Framework.getRuntime().getService(remoteItf);
    }

    public CoreSession openRepository(String repositoryName) throws Exception {
        return this.openRepository(repositoryName, null);
    }

    public synchronized CoreSession openRepository(String repositoryName, Map<String, Serializable> ctx) throws Exception {
        RepositoryManager repositoryMgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
        Repository repo = repositoryMgr.getRepository(repositoryName);
        if (repo != null) {
            if (ctx == null) {
                ctx = new HashMap<String, Serializable>();
            }
            return repo.open(ctx);
        }
        return null;
    }

    public synchronized ServerDescriptor[] getServers() {
        return this.servers.values().toArray(new ServerDescriptor[this.servers.size()]);
    }

    public Repository getDefaultRepository() {
        try {
            RepositoryManager repositoryMgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
            return repositoryMgr.getDefaultRepository();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized void dispose() {
        this.services.clear();
        this.services = null;
        this.repositories.clear();
        this.repositories = null;
        this.servers.clear();
        this.servers = null;
    }

    void registerService(ServiceDescriptor sd) {
        this.services.put(sd.serviceClass, sd);
    }

    void unregisterService(String className) {
        this.services.remove(className);
    }

    void registerRepository(RepositoryDescriptor rd) {
        this.repositories.put(rd.name, rd);
    }

    void unregisterRepository(String name) {
        this.repositories.remove(name);
    }

    private void registerPendingBindings(Server server) {
        List<ServerDescriptor> bindings = this.pendingBindings.remove(server.getName());
        if (bindings == null) {
            return;
        }
        for (ServerDescriptor sd : bindings) {
            if (sd.services != null) {
                server.registerServices(sd.services.values());
            }
            if (sd.repositories == null) continue;
            server.registerRepositories(sd.repositories.values());
        }
    }

    private void addToPendingQueue(ServerDescriptor sd) {
        List<ServerDescriptor> bindings = this.pendingBindings.get(sd.name);
        if (bindings == null) {
            bindings = new ArrayList<ServerDescriptor>();
            this.pendingBindings.put(sd.name, bindings);
        }
        bindings.add(sd);
    }
}

