/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.CannotConnectException;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.repository.LocalRepositoryInstanceHandler;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.client.DefaultLoginHandler;
import org.nuxeo.ecm.core.client.LoginHandler;
import org.nuxeo.ecm.core.client.NuxeoClient;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.CommandLineService;
import org.nuxeo.ecm.shell.commands.InteractiveCommand;
import org.nuxeo.runtime.api.Framework;

public class CommandContext
extends HashMap<String, Object> {
    private static final Log log = LogFactory.getLog(CommandContext.class);
    private static final long serialVersionUID = 921391738618179230L;
    private boolean interactive = false;
    private DocumentRef docRef;
    private CommandLine cmdLine;
    private RepositoryInstance repositoryInstance;
    private final CommandLineService service;
    private Collection<String> candidateHosts;
    private String host;
    private int port;
    private String username;
    private String password;

    public CommandContext(CommandLineService service) {
        this.service = service;
    }

    public Collection<String> getCandidateHosts() {
        return this.candidateHosts;
    }

    public void setCandidateHosts(Collection<String> candidateHosts) {
        this.candidateHosts = candidateHosts;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean value) {
        this.interactive = value;
    }

    public boolean isCurrentDocumentSet() {
        return this.docRef != null;
    }

    public boolean isCurrentRepositorySet() {
        return this.repositoryInstance != null;
    }

    public DocumentRef getCurrentDocument() throws Exception {
        if (this.docRef == null) {
            this.docRef = this.getRepositoryInstance().getRootDocument().getRef();
        }
        return this.docRef;
    }

    public void setCurrentDocument(DocumentRef docRef) {
        this.docRef = docRef;
    }

    public void setCurrentDocument(DocumentModel doc) {
        this.docRef = doc.getRef();
    }

    public CommandLine getCommandLine() {
        return this.cmdLine;
    }

    public void setCommandLine(CommandLine cmdLine) {
        this.cmdLine = cmdLine;
    }

    public void setRepositoryInstance(RepositoryInstance repository) {
        this.repositoryInstance = repository;
    }

    public DocumentModel fetchDocument() throws Exception {
        return this.getRepositoryInstance().getDocument(this.getCurrentDocument());
    }

    public DocumentModel fetchDocument(Path path) throws Exception {
        return this.getDocumentByPath(this.getCurrentDocument(), path);
    }

    public CommandLineService getService() {
        return this.service;
    }

    public boolean isLocal() {
        return this.candidateHosts == null;
    }

    public RepositoryInstance getCoreSession() throws Exception {
        return this.getRepositoryInstance();
    }

    public RepositoryInstance getRepositoryInstance() throws Exception {
        if (this.repositoryInstance == null) {
            if (!this.isLocal() && !NuxeoClient.getInstance().isConnected()) {
                this.initializeConnection();
            }
            String repoName = this.cmdLine.getOption("repository");
            this.repositoryInstance = this.isLocal() ? this.openLocalRepository(repoName) : (repoName == null ? NuxeoClient.getInstance().openRepository() : NuxeoClient.getInstance().openRepository(repoName));
        }
        return this.repositoryInstance;
    }

    protected void initializeConnection() throws Exception {
        this.askForCredentials();
        CannotConnectException exc = null;
        for (String h : this.candidateHosts) {
            try {
                log.info((Object)("Trying to connect to nuxeo server at " + h + ':' + this.port + " as " + (this.username == null ? "system user" : this.username) + "..."));
                NuxeoClient.getInstance().connect(h, this.port);
                this.host = h;
                break;
            }
            catch (CannotConnectException e) {
                exc = e;
            }
        }
        if (this.host == null) {
            throw new RuntimeException("Could not connect to server", exc);
        }
        log.info((Object)"Connection established");
    }

    protected void askForCredentials() throws IOException {
        if (this.password == null && this.interactive) {
            if (this.username == null || "system".equals(this.username)) {
                InteractiveCommand.getConsole().printString("Username? ");
                this.username = InteractiveCommand.getConsole().readLine();
            }
            InteractiveCommand.getConsole().printString("Password? ");
            this.password = InteractiveCommand.getConsole().readLine(new Character('*'));
        }
        if (this.username != null && !"system".equals(this.username)) {
            NuxeoClient.getInstance().setLoginHandler((LoginHandler)new DefaultLoginHandler(this.username, this.password));
        }
    }

    public RepositoryInstance openLocalRepository(String repoName) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        Repository repository = repoName == null ? repositoryManager.getDefaultRepository() : repositoryManager.getRepository(repoName);
        if (repository == null) {
            throw new IllegalArgumentException("No local repository" + (repoName == null ? "" : " named '" + repoName + "'"));
        }
        return new LocalRepositoryInstanceHandler(repository, this.username).getProxy();
    }

    public DocumentModel getDocumentByPath(DocumentRef base, Path path) throws Exception {
        RepositoryInstance repo = this.getRepositoryInstance();
        if (!path.isAbsolute()) {
            DocumentModel doc = repo.getDocument(base);
            path = doc.getPath().append(path);
            path = new Path(path.toString());
        }
        return repo.getDocument((DocumentRef)new PathRef(path.toString()));
    }
}

