/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.io;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.core.client.NuxeoClient;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelUpdater;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDirectoryReader;
import org.nuxeo.ecm.shell.Command;
import org.nuxeo.ecm.shell.CommandLine;

public class ImportCommand
implements Command {
    private static final Log log = LogFactory.getLog(ImportCommand.class);
    private final NuxeoClient client = NuxeoClient.getInstance();
    private RepositoryInstance repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine cmdLine) throws Exception {
        String[] elements = cmdLine.getParameters();
        if (elements.length != 2) {
            log.error((Object)"Usage : import src dest");
            return;
        }
        String path = elements[1];
        File file = new File(elements[0]);
        this.repository = this.client.openRepository();
        try {
            if (cmdLine.isOptionSet("update")) {
                this.importByID(file, path);
            } else {
                this.importTree(file, path);
            }
        }
        finally {
            this.repository.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importTree(File file, String toPath) throws Exception {
        XMLDirectoryReader reader = null;
        DocumentModelWriter writer = null;
        try {
            reader = new XMLDirectoryReader(file);
            writer = new DocumentModelWriter((CoreSession)this.repository, toPath, 10);
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importByID(File file, String toPath) throws Exception {
        if (toPath == null) {
            toPath = "/";
        }
        if (file == null) {
            log.error((Object)"Command Syntax Error. See help page");
            return;
        }
        if (!file.exists()) {
            log.error((Object)("File not found: " + file));
            return;
        }
        XMLDirectoryReader reader = null;
        DocumentModelUpdater writer = null;
        try {
            reader = new XMLDirectoryReader(file);
            writer = new DocumentModelUpdater((CoreSession)this.repository, toPath, 10);
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }
}

