/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class DoubleIndex
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(DoubleIndex.class);

    private void printHelp() {
        System.out.println("");
        System.out.println("Syntax: DoubleIndex doc_path [nb] ");
        System.out.println(" doc_path path of the doc to index");
        System.out.println(" nb number of sync indexing request inside transaction");
    }

    @Override
    public void run(CommandLine cmdLine) throws Exception {
        String docPath = null;
        int nb = 2;
        String[] elements = cmdLine.getParameters();
        if (elements.length >= 1) {
            if ("help".equals(elements[0])) {
                this.printHelp();
                return;
            }
            docPath = elements[0];
        }
        if (elements.length >= 2) {
            try {
                nb = Integer.parseInt(elements[1]);
            }
            catch (Throwable t) {
                log.error((Object)"Failed to parse nb");
                this.printHelp();
                return;
            }
        } else {
            this.printHelp();
            return;
        }
        this.index(docPath, nb);
    }

    public void index(String path, int nb) throws Exception {
        DocumentModel dm = this.context.getRepositoryInstance().getDocument((DocumentRef)new PathRef(path));
        String title = (String)dm.getProperty("dublincode", "title");
        for (int i = 0; i < nb - 1; ++i) {
            dm.setProperty("dublincore", "title", (Object)(title + i));
            this.context.getRepositoryInstance().saveDocument(dm);
        }
        dm.setProperty("dublincore", "title", (Object)title);
        this.context.getRepositoryInstance().saveDocument(dm);
        this.context.getRepositoryInstance().save();
    }
}

