/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.scripting;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class ScriptingCommand
extends AbstractCommand {
    protected static final ScriptEngineManager scriptMgr = new ScriptEngineManager();
    protected CompiledScript script;

    public ScriptingCommand(File file) throws ScriptException {
        this.script = ScriptingCommand.compileScript(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine cmdLine) throws Exception {
        SimpleBindings ctx = new SimpleBindings();
        ctx.put("cmdLine", (Object)cmdLine);
        ctx.put("ctx", (Object)this.context);
        ctx.put("client", (Object)this.client);
        ctx.put("service", (Object)this.cmdService);
        try {
            this.script.eval(ctx);
        }
        finally {
            System.out.flush();
        }
    }

    public static ScriptEngine getEngineByExtension(String extension) {
        return scriptMgr.getEngineByExtension(extension);
    }

    public static CompiledScript compileScript(File file) throws ScriptException {
        String ext = FileUtils.getFileExtension((String)file.getName());
        ScriptEngine engine = scriptMgr.getEngineByExtension(ext);
        return ScriptingCommand.compileScript(engine, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompiledScript compileScript(ScriptEngine engine, File file) throws ScriptException {
        if (engine instanceof Compilable) {
            CompiledScript compiledScript;
            Compilable comp = (Compilable)((Object)engine);
            FileReader reader = new FileReader(file);
            try {
                compiledScript = comp.compile(reader);
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ScriptException(e);
                }
            }
            ((Reader)reader).close();
            return compiledScript;
        }
        return null;
    }
}

