/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.indexing.resources.document.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.search.api.client.IndexingException;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.AbstractIndexableResource;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.document.NXCoreIndexableResource;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceConf;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractNXCoreIndexableResource
extends AbstractIndexableResource
implements NXCoreIndexableResource {
    private static final Log log = LogFactory.getLog(AbstractNXCoreIndexableResource.class);
    private static final long serialVersionUID = -5078465836275084998L;
    protected CoreSession coreSession;
    protected final String docRepositoryName;
    protected final String sid;

    protected AbstractNXCoreIndexableResource() {
        this.sid = null;
        this.docRepositoryName = null;
    }

    protected AbstractNXCoreIndexableResource(String name, IndexableResourceConf configuration) {
        super(name, configuration);
        this.sid = null;
        this.docRepositoryName = null;
    }

    protected AbstractNXCoreIndexableResource(String name, IndexableResourceConf configuration, String sid, String docRepositoryName) {
        super(name, configuration);
        this.docRepositoryName = docRepositoryName;
        this.sid = sid;
    }

    @Override
    public CoreSession getCoreSession() throws IndexingException {
        if (this.coreSession == null && this.docRepositoryName != null && !this.docRepositoryName.equals("")) {
            if (this.sid != null) {
                this.coreSession = CoreInstance.getInstance().getSession(this.sid);
                if (this.coreSession != null) {
                    log.debug((Object)"Using an app level managed Nuxeo Core session...");
                    return this.coreSession;
                }
                throw new IndexingException(String.format("the managed session %s is invalid", this.sid));
            }
            try {
                log.debug((Object)"Opening a new Session against Nuxeo Core");
                RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
                this.coreSession = mgr.getRepository(this.docRepositoryName).open();
            }
            catch (Exception e) {
                throw new IndexingException("Could not open new core session: " + e.getMessage(), e);
            }
        }
        return this.coreSession;
    }

    @Override
    public void closeCoreSession() throws IndexingException {
        try {
            if (this.sid == null && this.coreSession != null) {
                log.debug((Object)"Closing Nuxeo Core connection..");
                this.coreSession.cancel();
                CoreInstance.getInstance().close(this.coreSession);
                this.coreSession = null;
            }
        }
        catch (ClientException ce) {
            throw new IndexingException("error while disconnection core session: " + ce.getMessage(), ce);
        }
    }

    @Override
    public String getDocRepositoryName() {
        return this.docRepositoryName;
    }
}

