/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi;

import org.jboss.classloader.spi.filter.ClassFilter;

public class ParentPolicy {
    public static final ParentPolicy BEFORE = new ParentPolicy(ClassFilter.EVERYTHING, ClassFilter.NOTHING, "BEFORE");
    public static final ParentPolicy AFTER = new ParentPolicy(ClassFilter.NOTHING_BUT_JAVA, ClassFilter.EVERYTHING, "AFTER");
    public static final ParentPolicy BEFORE_BUT_JAVA_ONLY = new ParentPolicy(ClassFilter.JAVA_ONLY, ClassFilter.NOTHING, "BEFORE_BUT_JAVA_ONLY");
    public static final ParentPolicy AFTER_BUT_JAVA_BEFORE = new ParentPolicy(ClassFilter.JAVA_ONLY, ClassFilter.EVERYTHING, "AFTER_BUT_JAVA_BEFORE");
    public static final ParentPolicy AFTER_BUT_ONLY_JAVA_BEFORE = new ParentPolicy(ClassFilter.NOTHING_BUT_JAVA, ClassFilter.EVERYTHING, "AFTER_BUT_JAVA_BEFORE");
    private ClassFilter beforeFilter;
    private ClassFilter afterFilter;
    private String description;

    public ParentPolicy(ClassFilter beforeFilter, ClassFilter afterFilter) {
        this(beforeFilter, afterFilter, null);
    }

    public ParentPolicy(ClassFilter beforeFilter, ClassFilter afterFilter, String description) {
        if (beforeFilter == null) {
            throw new IllegalArgumentException("Null beforeFilter");
        }
        if (afterFilter == null) {
            throw new IllegalArgumentException("Null afterFilter");
        }
        this.beforeFilter = beforeFilter;
        this.afterFilter = afterFilter;
        this.description = description;
        if (description == null) {
            this.description = "(before=" + beforeFilter + " after=" + afterFilter + ")";
        }
    }

    public ClassFilter getBeforeFilter() {
        return this.beforeFilter;
    }

    public ClassFilter getAfterFilter() {
        return this.afterFilter;
    }

    public String toString() {
        return this.description;
    }
}

