/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.jboss.remoting.security.SSLSocketBuilderMBean;

public class CustomSSLServerSocketFactory
extends SSLServerSocketFactory {
    private SSLServerSocketFactory theDelegate;
    private SSLSocketBuilderMBean theBuilder;

    public CustomSSLServerSocketFactory(SSLServerSocketFactory factory, SSLSocketBuilderMBean builder) {
        this.theBuilder = builder;
        this.theDelegate = factory;
    }

    public CustomSSLServerSocketFactory() {
    }

    public void setSSLSocketBuilder(SSLSocketBuilderMBean sslSocketBuilder) {
        this.theBuilder = sslSocketBuilder;
    }

    public SSLSocketBuilderMBean getSSLSocketBuilder() {
        return this.theBuilder;
    }

    public void setFactory(SSLServerSocketFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory cannot be null");
        }
        this.theDelegate = factory;
    }

    public ServerSocket createServerSocket() throws IOException {
        SSLServerSocket sock = (SSLServerSocket)this.theDelegate.createServerSocket();
        this.setSocketModes(sock);
        return sock;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket sock = (SSLServerSocket)this.theDelegate.createServerSocket(port);
        this.setSocketModes(sock);
        return sock;
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket sock = (SSLServerSocket)this.theDelegate.createServerSocket(port, backlog);
        this.setSocketModes(sock);
        return sock;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket sock = (SSLServerSocket)this.theDelegate.createServerSocket(port, backlog, ifAddress);
        this.setSocketModes(sock);
        return sock;
    }

    public String[] getDefaultCipherSuites() {
        return this.theDelegate.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.theDelegate.getSupportedCipherSuites();
    }

    public boolean equals(Object obj) {
        return this.theDelegate.equals(obj);
    }

    public int hashCode() {
        return this.theDelegate.hashCode();
    }

    public String toString() {
        return this.theDelegate.toString();
    }

    private void setSocketModes(SSLServerSocket sock) {
        if (this.theBuilder != null) {
            boolean isServerSocketUseClientMode = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(CustomSSLServerSocketFactory.this.theBuilder.isServerSocketUseClientMode());
                }
            });
            boolean isClientAuthModeWant = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(CustomSSLServerSocketFactory.this.theBuilder.isClientAuthModeWant());
                }
            });
            boolean isClientAuthModeNeed = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(CustomSSLServerSocketFactory.this.theBuilder.isClientAuthModeNeed());
                }
            });
            sock.setUseClientMode(isServerSocketUseClientMode);
            if (isClientAuthModeWant) {
                sock.setNeedClientAuth(false);
                sock.setWantClientAuth(true);
            } else if (isClientAuthModeNeed) {
                sock.setWantClientAuth(false);
                sock.setNeedClientAuth(true);
            } else {
                sock.setWantClientAuth(false);
                sock.setNeedClientAuth(false);
            }
        }
    }
}

